"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDocIdWithScope = exports.PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_PRIORITY = exports.PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_ID = exports.DASHBOARD_ADMIN_SETTINGS_ID = exports.CURRENT_WORKSPACE_PLACEHOLDER = exports.CURRENT_USER_PLACEHOLDER = void 0;
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const CURRENT_USER_PLACEHOLDER = exports.CURRENT_USER_PLACEHOLDER = '<current_user>';
const CURRENT_WORKSPACE_PLACEHOLDER = exports.CURRENT_WORKSPACE_PLACEHOLDER = '<current_workspace>';
const DASHBOARD_ADMIN_SETTINGS_ID = exports.DASHBOARD_ADMIN_SETTINGS_ID = '_dashboard_admin';
const PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_ID = exports.PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_ID = 'permission-control-ui-settings';
// The wrapper handles the dashboard admin settings independently and will never conflict with
// other wrappers, therefore the priorty can be any number and the priority of 100 is trival
const PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_PRIORITY = exports.PERMISSION_CONTROLLED_UI_SETTINGS_WRAPPER_PRIORITY = 100;
const buildDocIdWithScope = (id, scope) => {
  if (scope === _types.UiSettingScope.USER) {
    return `${CURRENT_USER_PLACEHOLDER}_${id}`;
  }
  if (scope === _types.UiSettingScope.DASHBOARD_ADMIN) {
    return DASHBOARD_ADMIN_SETTINGS_ID;
  }
  if (scope === _types.UiSettingScope.WORKSPACE) {
    return `${CURRENT_WORKSPACE_PLACEHOLDER}_${id}`;
  }
  return id;
};
exports.buildDocIdWithScope = buildDocIdWithScope;