/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.semver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.semver.expr.Caret;
import org.opensearch.semver.expr.Equal;
import org.opensearch.semver.expr.Expression;
import org.opensearch.semver.expr.Range;
import org.opensearch.semver.expr.Tilde;

@PublicApi(since="2.13.0")
public class SemverRange
implements ToXContentFragment {
    public static final Pattern RANGE_PATTERN = Pattern.compile("([\\[\\(])([\\d.]+)\\s*,\\s*([\\d.]+)([\\]\\)])");
    private final Version rangeVersion;
    private final RangeOperator rangeOperator;
    private final Expression expression;

    public SemverRange(Version rangeVersion, RangeOperator rangeOperator) {
        this.rangeVersion = rangeVersion;
        this.rangeOperator = rangeOperator;
        this.expression = rangeOperator.expression;
    }

    public static SemverRange fromString(String range) {
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (matcher.matches()) {
            char leftBracket = matcher.group(1).charAt(0);
            String lowerVersionStr = matcher.group(2);
            String upperVersionStr = matcher.group(3);
            char rightBracket = matcher.group(4).charAt(0);
            Version lowerVersion = Version.fromString(matcher.group(2));
            Version upperVersion = Version.fromString(matcher.group(3));
            boolean includeLower = leftBracket == '[';
            boolean includeUpper = rightBracket == ']';
            Range rangeExpression = new Range(lowerVersion, upperVersion, includeLower, includeUpper);
            return new SemverRange(lowerVersion, RangeOperator.RANGE, rangeExpression);
        }
        RangeOperator rangeOperator = RangeOperator.fromRange(range);
        String version = range.replaceFirst(rangeOperator.asEscapedString(), "");
        if (!Version.stringHasLength(version)) {
            throw new IllegalArgumentException("Version cannot be empty");
        }
        return new SemverRange(Version.fromString(version), rangeOperator);
    }

    public SemverRange(Version rangeVersion, RangeOperator operator, Expression customExpression) {
        this.rangeVersion = rangeVersion;
        this.rangeOperator = operator;
        this.expression = customExpression;
    }

    public RangeOperator getRangeOperator() {
        return this.rangeOperator;
    }

    public Version getRangeVersion() {
        return this.rangeVersion;
    }

    public boolean isSatisfiedBy(String versionToEvaluate) {
        return this.isSatisfiedBy(Version.fromString(versionToEvaluate));
    }

    public boolean isSatisfiedBy(Version versionToEvaluate) {
        return this.expression.evaluate(this.rangeVersion, versionToEvaluate);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemverRange range = (SemverRange)o;
        return Objects.equals(this.rangeVersion, range.rangeVersion) && this.rangeOperator == range.rangeOperator && Objects.equals(this.expression, range.expression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rangeVersion, this.rangeOperator, this.expression});
    }

    public String toString() {
        if (this.rangeOperator == RangeOperator.RANGE && this.expression instanceof Range) {
            Range range = (Range)this.expression;
            return String.format(Locale.ROOT, "%s%s,%s%s", range.isIncludeLower() ? "[" : "(", range.getLowerBound(), range.getUpperBound(), range.isIncludeUpper() ? "]" : ")");
        }
        return this.rangeOperator.asString() + String.valueOf(this.rangeVersion);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public static enum RangeOperator {
        EQ("=", new Equal()),
        TILDE("~", new Tilde()),
        CARET("^", new Caret()),
        RANGE("range", new Range()),
        DEFAULT("", new Equal());

        private final String operator;
        private final Expression expression;

        private RangeOperator(String operator, Expression expression) {
            this.operator = operator;
            this.expression = expression;
        }

        public String asString() {
            return this.operator;
        }

        public String asEscapedString() {
            if (Objects.equals(this.operator, "^")) {
                return "\\^";
            }
            return this.operator;
        }

        public static RangeOperator fromRange(String range) {
            Optional<RangeOperator> rangeOperator = Arrays.stream(RangeOperator.values()).filter(operator -> operator != DEFAULT && range.startsWith(operator.asString())).findFirst();
            return rangeOperator.orElse(DEFAULT);
        }
    }
}

