/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.List;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.BoolQuery;
import org.opensearch.protobufs.MinimumShouldMatch;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

class BoolQueryBuilderProtoUtils {
    private BoolQueryBuilderProtoUtils() {
    }

    static BoolQueryBuilder fromProto(BoolQuery boolQueryProto, QueryBuilderProtoConverterRegistry registry) {
        String queryName = null;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        boolean adjustPureNegative = true;
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        if (boolQueryProto.hasXName()) {
            queryName = boolQueryProto.getXName();
            boolQuery.queryName(queryName);
        }
        if (boolQueryProto.hasBoost()) {
            boost = boolQueryProto.getBoost();
            boolQuery.boost(boost);
        }
        if (boolQueryProto.hasMinimumShouldMatch()) {
            MinimumShouldMatch minimumShouldMatchProto = boolQueryProto.getMinimumShouldMatch();
            switch (minimumShouldMatchProto.getMinimumShouldMatchCase()) {
                case INT32: {
                    minimumShouldMatch = String.valueOf(minimumShouldMatchProto.getInt32());
                    break;
                }
                case STRING: {
                    minimumShouldMatch = minimumShouldMatchProto.getString();
                    break;
                }
            }
            if (minimumShouldMatch != null) {
                boolQuery.minimumShouldMatch(minimumShouldMatch);
            }
        }
        List mustClauses = boolQueryProto.getMustList();
        for (Object queryContainer : mustClauses) {
            QueryBuilder queryBuilder = registry.fromProto((QueryContainer)queryContainer);
            if (queryBuilder == null) continue;
            boolQuery.must(queryBuilder);
        }
        List mustNotClauses = boolQueryProto.getMustNotList();
        for (Object queryContainer : mustNotClauses) {
            QueryBuilder queryBuilder = registry.fromProto((QueryContainer)queryContainer);
            if (queryBuilder == null) continue;
            boolQuery.mustNot(queryBuilder);
        }
        List shouldClauses = boolQueryProto.getShouldList();
        for (QueryContainer queryContainer : shouldClauses) {
            QueryBuilder queryBuilder = registry.fromProto(queryContainer);
            if (queryBuilder == null) continue;
            boolQuery.should(queryBuilder);
        }
        List filterClauses = boolQueryProto.getFilterList();
        for (QueryContainer queryContainer : filterClauses) {
            QueryBuilder queryBuilder = registry.fromProto(queryContainer);
            if (queryBuilder == null) continue;
            boolQuery.filter(queryBuilder);
        }
        if (boolQueryProto.hasAdjustPureNegative()) {
            adjustPureNegative = boolQueryProto.getAdjustPureNegative();
            boolQuery.adjustPureNegative(adjustPureNegative);
        }
        return boolQuery;
    }
}

