/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;

public final class CountFunction<K, V, T>
implements SortedSetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<CountFunction> EXTERNALIZER = new Externalizer();
    private final T min;
    private final T max;
    private final boolean includeMin;
    private final boolean includeMax;
    private final SortedSetOperationType countType;

    public CountFunction(T min, boolean includeMin, T max, boolean includeMax, SortedSetOperationType countType) {
        this.min = min;
        this.includeMin = includeMin;
        this.max = max;
        this.includeMax = includeMax;
        this.countType = countType;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        long count = 0L;
        if (existing.isPresent()) {
            switch (this.countType) {
                case LEX: {
                    return ((SortedSetBucket)existing.get()).subset(this.min, this.includeMin, this.max, this.includeMax, false, null, null).size();
                }
                case SCORE: {
                    return ((SortedSetBucket)existing.get()).subset((Double)this.min, this.includeMin, (Double)this.max, this.includeMax, false, (Long)null, (Long)null).size();
                }
            }
        }
        return count;
    }

    private static class Externalizer
    implements AdvancedExternalizer<CountFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CountFunction>> getTypeClasses() {
            return Collections.singleton(CountFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_COUNT_FUNCTION;
        }

        public void writeObject(ObjectOutput output, CountFunction object) throws IOException {
            output.writeObject(object.min);
            output.writeBoolean(object.includeMin);
            output.writeObject(object.max);
            output.writeBoolean(object.includeMax);
            MarshallUtil.marshallEnum((Enum)object.countType, (ObjectOutput)output);
        }

        public CountFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CountFunction(input.readObject(), input.readBoolean(), input.readObject(), input.readBoolean(), (SortedSetOperationType)MarshallUtil.unmarshallEnum((ObjectInput)input, SortedSetOperationType::valueOf));
        }
    }
}

