/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.BS;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.viewer.JC;

public abstract class BioShapeCollection
extends Shape {
    Atom[] atoms;
    short madOn = (short)-2;
    short madHelixSheet = (short)3000;
    short madTurnRandom = (short)800;
    short madDnaRna = (short)5000;
    boolean isActive = false;
    public BioShape[] bioShapes;

    @Override
    public final void initModelSet() {
        this.isBioShape = true;
        this.atoms = this.ms.at;
        this.initialize();
    }

    @Override
    public void initShape() {
    }

    @Override
    public int getSizeG(Group group) {
        Monomer m = (Monomer)group;
        int groupIndex = m.groupIndex;
        int leadAtomIndex = m.getLeadAtom().i;
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape bioShape = this.bioShapes[i];
            for (int j = 0; j < bioShape.monomerCount; ++j) {
                if (bioShape.monomers[j].groupIndex != groupIndex || bioShape.monomers[j].getLeadAtom().i != leadAtomIndex) continue;
                return bioShape.mads[j];
            }
        }
        return 0;
    }

    @Override
    public void replaceGroup(Group g0, Group g1) {
        int i = this.bioShapes.length;
        block0: while (--i >= 0) {
            BioShape bioShape = this.bioShapes[i];
            for (int j = 0; j < bioShape.monomerCount; ++j) {
                if (bioShape.monomers[j] != g0) continue;
                bioShape.monomers[j] = (Monomer)g1;
                continue block0;
            }
        }
    }

    @Override
    public void setShapeSizeRD(int size, RadiusData rd, BS bsSelected) {
        short mad = (short)size;
        this.initialize();
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape bioShape = this.bioShapes[i];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setMad(mad, bsSelected, rd == null ? null : rd.values);
        }
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bsSelected) {
        this.setPropBSC(propertyName, value, bsSelected);
    }

    protected void setPropBSC(String propertyName, Object value, BS bsSelected) {
        if (propertyName == "refreshTrajectories") {
            int modelIndex = (Integer)((Object[])value)[0];
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape b = this.bioShapes[i];
                if (b.modelIndex != modelIndex) continue;
                b.falsifyMesh();
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])value)[1];
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape b = this.bioShapes[i];
                if (b.modelIndex > modelIndex) {
                    --b.modelIndex;
                    b.leadAtomIndices = b.bioPolymer.getLeadAtomIndices();
                    continue;
                }
                if (b.modelIndex != modelIndex) continue;
                this.bioShapes = (BioShape[])AU.deleteElements(this.bioShapes, i, 1);
            }
            return;
        }
        this.initialize();
        if ("color" == propertyName) {
            byte pid = PAL.pidOf(value);
            short colix = C.getColixO(value);
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape bioShape = this.bioShapes[i];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColixBS(colix, pid, bsSelected);
            }
            return;
        }
        if ("pymolparams" == propertyName) {
            int n = bsSelected.length();
            int[] atomMap = new int[n];
            int pt = 0;
            int i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                atomMap[i] = pt++;
                i = bsSelected.nextSetBit(i + 1);
            }
            int i2 = this.bioShapes.length;
            while (--i2 >= 0) {
                this.bioShapes[i2].setParams((Object[])value, atomMap, bsSelected);
            }
            return;
        }
        if ("colorPhase" == propertyName) {
            Object[] twoColors = (Object[])value;
            short colixBack = C.getColixO(twoColors[0]);
            short colix = C.getColixO(twoColors[1]);
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape bioShape = this.bioShapes[i];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColixBS(colix, (byte)64, bsSelected);
                bioShape.setColixBack(colixBack, bsSelected);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent".equals(value);
            int i = this.bioShapes.length;
            while (--i >= 0) {
                BioShape bioShape = this.bioShapes[i];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setTranslucent(isTranslucent, bsSelected, this.translucentLevel);
            }
            return;
        }
        this.setPropS(propertyName, value, bsSelected);
    }

    @Override
    public String getShapeState() {
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        Hashtable<String, BS> temp2 = new Hashtable<String, BS>();
        String type = JC.shapeClassBases[this.shapeID];
        int iShape = this.bioShapes.length;
        while (--iShape >= 0) {
            this.bioShapes[iShape].getBioShapeState(type, this.translucentAllowed, temp, temp2);
        }
        String s = "\n" + this.vwr.getCommands(temp, temp2, this.shapeID == 9 ? "Backbone" : "select");
        return s;
    }

    void initialize() {
        int modelCount = this.ms.mc;
        Model[] models = this.ms.am;
        int n = this.ms.getBioPolymerCountInModel(-1);
        BioShape[] shapes = new BioShape[n--];
        int i = modelCount;
        while (--i >= 0) {
            int j = this.ms.getBioPolymerCountInModel(i);
            while (--j >= 0) {
                BioPolymer bp = ((BioModel)models[i]).bioPolymers[j];
                shapes[n] = this.bioShapes == null || this.bioShapes.length <= n || this.bioShapes[n] == null || this.bioShapes[n].bioPolymer != bp ? new BioShape(this, i, bp) : this.bioShapes[n];
                --n;
            }
        }
        this.bioShapes = shapes;
    }

    @Override
    public void findNearestAtomIndex(int xMouse, int yMouse, Atom[] closest, BS bsNot) {
        int i = this.bioShapes.length;
        while (--i >= 0) {
            this.bioShapes[i].findNearestAtomIndex(xMouse, yMouse, closest, bsNot);
        }
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        if (this.bioShapes == null) {
            return;
        }
        bsModels = BSUtil.copy(bsModels);
        if (this.ms.trajectory != null) {
            this.ms.trajectory.setBaseModels(bsModels);
        }
        int i = this.bioShapes.length;
        while (--i >= 0) {
            BioShape b = this.bioShapes[i];
            b.modelVisibilityFlags = bsModels.get(b.modelIndex) ? this.vf : 0;
        }
    }

    @Override
    public void setAtomClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int i = this.bioShapes.length;
        while (--i >= 0) {
            this.bioShapes[i].setAtomClickability();
        }
    }

    int getMpsShapeCount() {
        return this.bioShapes.length;
    }

    public BioShape getBioShape(int i) {
        return this.bioShapes[i];
    }
}

