/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SecurityCertificate;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SecurityDataDirectory
extends DataDirectory
implements ByteArrayConverter {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_SECURITY";
    private SecurityCertificate[] certificates;

    SecurityDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.certificates == null) {
            this.certificates = new SecurityCertificate[0];
        }
    }

    public SecurityCertificate[] getCertificate() {
        return this.certificates;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        if (!isBinary) {
            return;
        }
        monitor.setMessage(program.getName() + ": security data...");
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address addr = space.getAddress((long)this.virtualAddress);
        this.createDirectoryBookmark(program, addr);
        program.getListing().clearCodeUnits(addr, addr, false);
        for (SecurityCertificate cert : this.certificates) {
            DataType dt = cert.toDataType();
            program.getListing().createData(addr, dt);
            addr = addr.add((long)dt.getLength());
        }
    }

    @Override
    public boolean parse() throws IOException {
        int certSize;
        ArrayList<SecurityCertificate> list = new ArrayList<SecurityCertificate>();
        if (!this.reader.isValidIndex(this.getVirtualAddress())) {
            Msg.warn((Object)this, (Object)"Certificate address is not valid.");
            return false;
        }
        int certOffset = this.getVirtualAddress();
        if ((long)(certOffset + (certSize = this.getSize())) > this.reader.length()) {
            Msg.warn((Object)this, (Object)("Certificate length " + certSize + " exceeds EOF."));
            return false;
        }
        while (certSize > 0 && certSize < 65536) {
            SecurityCertificate cert = SecurityCertificate.read(this.reader, certOffset, certSize);
            if (cert == null) {
                return false;
            }
            list.add(cert);
            int certBytesUsed = cert.getNumberOfBytesConsumed();
            certOffset += certBytesUsed;
            certSize -= certBytesUsed;
        }
        this.certificates = new SecurityCertificate[list.size()];
        list.toArray(this.certificates);
        return true;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        try {
            return this.reader.readByteArray(this.virtualAddress, this.size);
        }
        catch (IOException e) {
            return new byte[this.size];
        }
    }

    @Override
    public void writeBytes(RandomAccessFile raf, DataConverter dc, PortableExecutable template) throws IOException {
        if (this.size == 0) {
            return;
        }
        DataDirectory[] originalDataDirs = template.getNTHeader().getOptionalHeader().getDataDirectories();
        if (originalDataDirs.length > 4 && (originalDataDirs[4] == null || originalDataDirs[4].getSize() == 0)) {
            return;
        }
        if (originalDataDirs.length > 4) {
            SecurityDataDirectory originalSDD = (SecurityDataDirectory)originalDataDirs[4];
            raf.seek(this.rvaToPointer());
            raf.write(originalSDD.toBytes(dc));
        }
    }

    @Override
    int rvaToPointer() {
        return this.virtualAddress;
    }

    void updatePointers(int offset) {
        this.virtualAddress += offset;
    }

    public Address getMarkupAddress(Program program, boolean isBinary) {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        return space.getAddress((long)this.virtualAddress);
    }
}

