/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.ClassCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.ExportsCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.FunctionCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.ImportsCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.LabelCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.NamespaceCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class SymbolTreeRootNode
extends GTreeNode {
    private static Icon GLOBAL_ICON = new GIcon("icon.plugin.symboltree.node.root");
    private final String name;
    protected SymbolCategory symbolCategory;
    protected Program program;
    private int groupThreshold;

    public SymbolTreeRootNode(Program program, int groupThreshold) {
        this.groupThreshold = groupThreshold;
        this.symbolCategory = SymbolCategory.ROOT_CATEGORY;
        this.program = program;
        this.name = program == null ? "No Symbol Tree" : "Global";
    }

    public int getNodeGroupThreshold() {
        return this.groupThreshold;
    }

    public int getReorganizeLimit() {
        return this.groupThreshold * 2;
    }

    public Program getProgram() {
        return this.program;
    }

    public List<GTreeNode> generateChildren() {
        if (this.program == null) {
            return Collections.emptyList();
        }
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        list.add((GTreeNode)new ImportsCategoryNode(this.program));
        list.add((GTreeNode)new ExportsCategoryNode(this.program));
        list.add((GTreeNode)new FunctionCategoryNode(this.program));
        list.add((GTreeNode)new LabelCategoryNode(this.program));
        list.add((GTreeNode)new ClassCategoryNode(this.program));
        list.add((GTreeNode)new NamespaceCategoryNode(this.program));
        return list;
    }

    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        Symbol searchSymbol = key.getSymbol();
        SymbolType type = searchSymbol.getSymbolType();
        if (type == SymbolType.FUNCTION) {
            return this.findFunctionSymbolNode(key, loadChildren, monitor);
        }
        if (type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR) {
            return this.findVariableSymbolNode(key, loadChildren, monitor);
        }
        if (type == SymbolType.CLASS) {
            return this.findClassSymbol(key, loadChildren, monitor);
        }
        if (type == SymbolType.LIBRARY || type == SymbolType.NAMESPACE) {
            return this.findNamespaceSymbol(key, loadChildren, monitor);
        }
        if (type == SymbolType.LABEL) {
            return this.findCodeSymbol(key, loadChildren, monitor);
        }
        return null;
    }

    private GTreeNode findCodeSymbol(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        List<SymbolCategoryNode> categories = Arrays.asList(this.getLabelsNode(), this.getNamespacesNode(), this.getClassesNode(), this.getFunctionsNode());
        GTreeNode node = this.searchCategories(categories, key, loadChildren, monitor);
        return node;
    }

    private GTreeNode findNamespaceSymbol(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        SymbolCategoryNode category = this.getNamespacesNode();
        return category.findSymbolTreeNode(key, loadChildren, monitor);
    }

    private GTreeNode findClassSymbol(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        SymbolCategoryNode category = this.getClassesNode();
        return category.findSymbolTreeNode(key, loadChildren, monitor);
    }

    private GTreeNode findVariableSymbolNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        Symbol searchSymbol = key.getSymbol();
        Symbol functionSymbol = searchSymbol.getParentSymbol();
        SymbolNode parentKey = SymbolNode.createNode(functionSymbol, this.program);
        GTreeNode functionNode = this.findFunctionSymbolNode(parentKey, loadChildren, monitor);
        if (functionNode != null) {
            return ((SymbolTreeNode)functionNode).findSymbolTreeNode(key, loadChildren, monitor);
        }
        return null;
    }

    private GTreeNode findFunctionSymbolNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        Symbol searchSymbol = key.getSymbol();
        if (searchSymbol.isExternal()) {
            return this.searchCategory(this.getExternalsNode(), key, loadChildren, monitor);
        }
        List<SymbolCategoryNode> categories = Arrays.asList(this.getFunctionsNode(), this.getClassesNode(), this.getNamespacesNode());
        GTreeNode node = this.searchCategories(categories, key, loadChildren, monitor);
        return node;
    }

    private GTreeNode searchCategories(List<SymbolCategoryNode> categories, SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        for (SymbolCategoryNode category : categories) {
            GTreeNode node = this.searchCategory(category, key, loadChildren, monitor);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private GTreeNode searchCategory(SymbolCategoryNode category, SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        if (category == null) {
            return null;
        }
        GTreeNode node = category.findSymbolTreeNode(key, loadChildren, monitor);
        return node;
    }

    private SymbolCategoryNode getLabelsNode() {
        List children = this.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof LabelCategoryNode)) continue;
            return (SymbolCategoryNode)child;
        }
        return null;
    }

    private SymbolCategoryNode getFunctionsNode() {
        List children = this.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof FunctionCategoryNode)) continue;
            return (SymbolCategoryNode)child;
        }
        return null;
    }

    private SymbolCategoryNode getExternalsNode() {
        List children = this.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof FunctionCategoryNode)) continue;
            return (SymbolCategoryNode)child;
        }
        return null;
    }

    private SymbolCategoryNode getClassesNode() {
        List children = this.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof ClassCategoryNode)) continue;
            return (SymbolCategoryNode)child;
        }
        return null;
    }

    private SymbolCategoryNode getNamespacesNode() {
        List children = this.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof NamespaceCategoryNode)) continue;
            return (SymbolCategoryNode)child;
        }
        return null;
    }

    public SymbolNode symbolAdded(Symbol symbol, TaskMonitor monitor) {
        SymbolNode returnNode = null;
        List allChildren = this.getChildren();
        for (GTreeNode gNode : allChildren) {
            SymbolCategoryNode symbolNode = (SymbolCategoryNode)gNode;
            SymbolNode newNode = symbolNode.symbolAdded(symbol, monitor);
            if (newNode == null) continue;
            returnNode = newNode;
        }
        return returnNode;
    }

    public void symbolRemoved(Symbol symbol, String oldName, TaskMonitor monitor) {
        List allChildren = this.getChildren();
        for (GTreeNode gNode : allChildren) {
            SymbolCategoryNode symbolNode = (SymbolCategoryNode)gNode;
            symbolNode.symbolRemoved(symbol, oldName, monitor);
        }
    }

    public void symbolRemoved(Symbol symbol, Namespace oldNamespace, TaskMonitor monitor) {
        List allChildren = this.getChildren();
        for (GTreeNode gNode : allChildren) {
            SymbolCategoryNode symbolNode = (SymbolCategoryNode)gNode;
            symbolNode.symbolRemoved(symbol, oldNamespace, monitor);
        }
    }

    public void rebuild() {
        this.setChildren(null);
    }

    public Icon getIcon(boolean expanded) {
        return GLOBAL_ICON;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return this.program == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolTreeRootNode)) {
            return false;
        }
        SymbolTreeRootNode node = (SymbolTreeRootNode)((Object)o);
        return this.getName().equals(node.getName());
    }
}

