/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.constraint.DecisionSet;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.constraint.ProgramDecisionTree;
import ghidra.xml.XmlParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NonReturningFunctionNames {
    private static final String CONSTRAINED_FILENAME_PROPERTY = "functionNamesFile";
    private static final String DATA_DIR = "data";
    private static ProgramDecisionTree decisionTree;

    private NonReturningFunctionNames() {
    }

    static synchronized ProgramDecisionTree getDecisionTree() {
        if (decisionTree != null) {
            return decisionTree;
        }
        List dataDirs = Application.findModuleSubDirectories((String)DATA_DIR);
        List<ResourceFile> fileList = NonReturningFunctionNames.findDataFiles(dataDirs);
        decisionTree = new ProgramDecisionTree();
        decisionTree.registerPropertyName(CONSTRAINED_FILENAME_PROPERTY);
        for (ResourceFile resourceFile : fileList) {
            try {
                decisionTree.loadConstraints(resourceFile);
            }
            catch (Exception e) {
                Msg.showError(NonReturningFunctionNames.class, null, (String)"Error Processing Pattern File", (Object)("Error processing pattern file " + String.valueOf(resourceFile) + "\n" + e.getMessage()));
            }
        }
        return decisionTree;
    }

    static boolean hasDataFiles(Program program) {
        DecisionSet decisionsSet = NonReturningFunctionNames.getDecisionTree().getDecisionsSet((Object)program, CONSTRAINED_FILENAME_PROPERTY);
        return !decisionsSet.isEmpty();
    }

    static ResourceFile[] findDataFiles(Program program) throws FileNotFoundException, IOException, XmlParseException {
        DecisionSet decisionsSet = NonReturningFunctionNames.getDecisionTree().getDecisionsSet((Object)program, CONSTRAINED_FILENAME_PROPERTY);
        List values = decisionsSet.getValues();
        ArrayList<ResourceFile> fileList = new ArrayList<ResourceFile>();
        List dataDirs = Application.findModuleSubDirectories((String)DATA_DIR);
        for (String patternFileName : values) {
            fileList.add(NonReturningFunctionNames.getDataFile(dataDirs, patternFileName));
        }
        return fileList.toArray(new ResourceFile[fileList.size()]);
    }

    private static ResourceFile getDataFile(List<ResourceFile> dataDirs, String fileName) throws FileNotFoundException {
        for (ResourceFile dir : dataDirs) {
            ResourceFile file = new ResourceFile(dir, fileName);
            if (!file.exists()) continue;
            return file;
        }
        throw new FileNotFoundException("can't find data file: " + fileName);
    }

    private static List<ResourceFile> findDataFiles(List<ResourceFile> patternDirs) {
        ArrayList<ResourceFile> patternConstraintFiles = new ArrayList<ResourceFile>();
        for (ResourceFile dir : patternDirs) {
            ResourceFile file = new ResourceFile(dir, "noReturnFunctionConstraints.xml");
            if (!file.exists()) continue;
            patternConstraintFiles.add(file);
        }
        return patternConstraintFiles;
    }
}

