/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.datatypes;

import ghidra.app.util.bin.format.swift.SwiftTypeMetadata;
import ghidra.app.util.bin.format.swift.types.FieldDescriptor;
import ghidra.app.util.bin.format.swift.types.FieldRecord;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledStructure;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;

public class SwiftStructure
extends DemangledStructure {
    public SwiftStructure(String mangled, String originalDemangled, String name, Demangled namespace, SwiftDemangler demangler) throws DemangledException {
        super(mangled, originalDemangled, name, SwiftDataTypeUtils.getCategoryPath(namespace).getPath(), true);
        FieldDescriptor fieldDescriptor;
        TargetTypeContextDescriptor typeDescriptor;
        this.setNamespace(namespace);
        SwiftTypeMetadata typeMetadata = demangler.getTypeMetadata();
        if (typeMetadata != null && (typeDescriptor = (TargetTypeContextDescriptor)typeMetadata.getTargetTypeContextDescriptors().get(name)) != null && (fieldDescriptor = typeDescriptor.getFieldDescriptor(typeMetadata.getFieldDescriptors())) != null) {
            for (FieldRecord fieldRecord : fieldDescriptor.getFieldRecords()) {
                String mangledType = "_T" + fieldRecord.getMangledTypeName();
                Demangled demangled = demangler.getDemangled(mangledType, null);
                if (!(demangled instanceof DemangledDataType)) continue;
                DemangledDataType ddt = (DemangledDataType)demangled;
                this.addField(fieldRecord.getFieldName(), fieldRecord.getDescription(), ddt);
            }
        }
    }
}

