/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.KeyBindingPrecedence;
import docking.actions.KeyBindingUtils;
import ghidra.framework.options.ActionTrigger;
import gui.event.MouseBinding;
import java.util.Objects;
import javax.swing.KeyStroke;

public class KeyBindingData {
    private KeyStroke keyStroke;
    private KeyBindingPrecedence keyBindingPrecedence = KeyBindingPrecedence.DefaultLevel;
    private MouseBinding mouseBinding;

    public KeyBindingData(KeyStroke keyStroke) {
        this(keyStroke, KeyBindingPrecedence.DefaultLevel);
    }

    public KeyBindingData(char c, int modifiers) {
        this((int)Character.toUpperCase(c), modifiers);
    }

    public KeyBindingData(int keyCode, int modifiers) {
        this(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public KeyBindingData(MouseBinding mouseBinding) {
        this.mouseBinding = Objects.requireNonNull(mouseBinding);
    }

    public KeyBindingData(String keyStrokeString) {
        this(KeyBindingData.parseKeyStrokeString(keyStrokeString));
    }

    public KeyBindingData(ActionTrigger actionTrigger) {
        Objects.requireNonNull(actionTrigger);
        this.keyStroke = actionTrigger.getKeyStroke();
        this.mouseBinding = actionTrigger.getMouseBinding();
    }

    public KeyBindingData(KeyStroke keyStroke, KeyBindingPrecedence precedence) {
        if (precedence == KeyBindingPrecedence.SystemActionsLevel) {
            throw new IllegalArgumentException("Can't set precedence to System KeyBindingPrecedence");
        }
        this.keyStroke = Objects.requireNonNull(keyStroke);
        this.keyBindingPrecedence = Objects.requireNonNull(precedence);
    }

    private static KeyStroke parseKeyStrokeString(String keyStrokeString) {
        KeyStroke keyStroke = KeyBindingUtils.parseKeyStroke(keyStrokeString);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Invalid keystroke string: " + keyStrokeString);
        }
        return keyStroke;
    }

    public static KeyBindingData update(KeyBindingData kbData, ActionTrigger newTrigger) {
        if (kbData == null) {
            if (newTrigger == null) {
                return null;
            }
            return new KeyBindingData(newTrigger);
        }
        if (newTrigger == null) {
            return null;
        }
        ActionTrigger existingTrigger = kbData.getActionTrigger();
        if (existingTrigger.equals((Object)newTrigger)) {
            return kbData;
        }
        return new KeyBindingData(newTrigger);
    }

    public KeyStroke getKeyBinding() {
        return this.keyStroke;
    }

    public KeyBindingPrecedence getKeyBindingPrecedence() {
        return this.keyBindingPrecedence;
    }

    public MouseBinding getMouseBinding() {
        return this.mouseBinding;
    }

    public ActionTrigger getActionTrigger() {
        return new ActionTrigger(this.keyStroke, this.mouseBinding);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[KeyStroke=" + String.valueOf(this.keyStroke) + ", precedence=" + String.valueOf((Object)this.keyBindingPrecedence) + ", MouseBinding=" + String.valueOf(this.mouseBinding) + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyBindingPrecedence, this.keyStroke, this.mouseBinding});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyBindingData other = (KeyBindingData)obj;
        if (this.keyBindingPrecedence != other.keyBindingPrecedence) {
            return false;
        }
        if (!Objects.equals(this.keyStroke, other.keyStroke)) {
            return false;
        }
        return Objects.equals(this.mouseBinding, other.mouseBinding);
    }

    static KeyBindingData createSystemKeyBindingData(KeyStroke keyStroke) {
        KeyBindingData keyBindingData = new KeyBindingData(keyStroke);
        keyBindingData.keyBindingPrecedence = KeyBindingPrecedence.SystemActionsLevel;
        return keyBindingData;
    }

    static KeyBindingData validateKeyBindingData(KeyBindingData newKeyBindingData) {
        if (newKeyBindingData == null) {
            return null;
        }
        KeyStroke keyBinding = newKeyBindingData.getKeyBinding();
        if (keyBinding == null) {
            return newKeyBindingData;
        }
        KeyBindingPrecedence precedence = newKeyBindingData.getKeyBindingPrecedence();
        if (precedence == KeyBindingPrecedence.SystemActionsLevel) {
            KeyBindingData kbd = KeyBindingData.createSystemKeyBindingData(KeyBindingUtils.validateKeyStroke(keyBinding));
            kbd.mouseBinding = newKeyBindingData.mouseBinding;
            return kbd;
        }
        KeyBindingData kbd = new KeyBindingData(KeyBindingUtils.validateKeyStroke(keyBinding), precedence);
        kbd.mouseBinding = newKeyBindingData.mouseBinding;
        return kbd;
    }
}

