/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import generic.lsh.vector.IDFLookup;
import ghidra.features.bsim.query.client.tables.SQLComplexTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class IdfLookupTable
extends SQLComplexTable {
    public IdfLookupTable() {
        super("idflookup", null);
    }

    @Override
    public void create(Statement st) throws SQLException {
        st.executeUpdate("CREATE TABLE idflookup(hash bigint,lookup integer)");
    }

    @Override
    public void drop(Statement st) throws SQLException {
        String sql = "DROP TABLE IF EXISTS " + this.tableName;
        st.executeUpdate(sql);
    }

    @Override
    public long insert(Object ... arguments) throws SQLException {
        if (arguments == null || arguments.length != 2) {
            throw new IllegalArgumentException("Insert method for IdfLookupTable must take exactly two integer arguments");
        }
        try (Statement st = this.db.createStatement();){
            int cnt = (Integer)arguments[0];
            if (cnt == -1) {
                long l = 0L;
                return l;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("INSERT INTO idflookup (hash,lookup) VALUES(");
            long rawhash = ((Integer)arguments[1]).intValue();
            if (rawhash < 0L) {
                rawhash += 0x100000000L;
            }
            buf.append(rawhash);
            buf.append(',').append(cnt).append(')');
            st.executeUpdate(buf.toString());
            long l = 0L;
            return l;
        }
    }

    public void recoverIDFLookup(IDFLookup lookup) throws SQLException {
        try (Statement st = this.db.createStatement();
             ResultSet rs = st.executeQuery("SELECT ALL * from idflookup");){
            int[] buffer = new int[5000];
            int numentries = 0;
            while (rs.next()) {
                buffer[numentries] = (int)rs.getLong(1);
                buffer[++numentries] = rs.getInt(2);
                ++numentries;
            }
            int[] finalArray = new int[numentries];
            for (int i = 0; i < finalArray.length; ++i) {
                finalArray[i] = buffer[i];
            }
            lookup.set(finalArray);
        }
    }
}

