/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.constraint;

import generic.constraint.ConstraintData;
import ghidra.program.model.listing.Program;
import ghidra.util.constraint.ProgramConstraint;
import ghidra.util.xml.XmlAttributeException;
import java.util.Objects;

public class CompilerConstraint
extends ProgramConstraint {
    private String compilerid;
    private String compilerName;

    public CompilerConstraint() {
        super("compiler");
    }

    public boolean isSatisfied(Program program) {
        if (this.compilerid == null && this.compilerName == null) {
            return false;
        }
        boolean satisfied = true;
        if (this.compilerid != null) {
            satisfied &= this.compilerid.equals(program.getCompilerSpec().getCompilerSpecID().getIdAsString());
        }
        if (this.compilerName != null) {
            satisfied &= this.compilerName.contains(program.getCompiler());
        }
        return satisfied;
    }

    public void loadConstraintData(ConstraintData data) {
        if (data.hasValue("id")) {
            this.compilerid = data.getString("id");
        }
        if (data.hasValue("name")) {
            this.compilerName = data.getString("name");
        }
        if (this.compilerid == null && this.compilerName == null) {
            throw new XmlAttributeException("Missing both id and name attributes");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompilerConstraint)) {
            return false;
        }
        CompilerConstraint constraint = (CompilerConstraint)((Object)obj);
        if (!(this.compilerid == constraint.compilerid || this.compilerid != null && this.compilerid.equals(constraint.compilerid))) {
            return false;
        }
        return this.compilerName == constraint.compilerName || this.compilerName != null && this.compilerName.equals(constraint.compilerName);
    }

    public int hashCode() {
        return Objects.hash(this.compilerid, this.compilerName);
    }

    public String getDescription() {
        return "compiler = " + this.compilerid + " compilerName = " + this.compilerName;
    }
}

