/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;

public class DBTraceThreadManager
implements TraceThreadManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceObjectManager objectManager;

    public DBTraceThreadManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceObjectManager objectManager) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        this.objectManager = objectManager;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    public TraceThread assertIsMine(TraceThread thread) {
        return this.objectManager.assertMyThread(thread);
    }

    @Override
    public TraceThread addThread(String path, Lifespan lifespan) throws DuplicateNameException {
        return this.addThread(path, path, lifespan);
    }

    @Override
    public TraceThread addThread(String path, String display, Lifespan lifespan) throws DuplicateNameException {
        return this.objectManager.addThread(path, display, lifespan);
    }

    @Override
    public Collection<? extends TraceThread> getAllThreads() {
        return this.objectManager.getAllObjects(TraceThread.class);
    }

    @Override
    public Collection<? extends TraceThread> getThreadsByPath(String path) {
        return this.objectManager.getObjectsByPath(path, TraceThread.class);
    }

    @Override
    public TraceThread getLiveThreadByPath(long snap, String path) {
        return this.objectManager.getObjectByPath(snap, path, TraceThread.class);
    }

    @Override
    public TraceThread getThread(long key) {
        DBTraceObject object = this.objectManager.getObjectById(key);
        return object == null ? null : object.queryInterface(TraceThread.class);
    }

    @Override
    public Collection<? extends TraceThread> getLiveThreads(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Collection collection = this.objectManager.queryAllInterface(Lifespan.at(snap), TraceThread.class).collect(Collectors.toSet());
            return collection;
        }
    }
}

