/*
 * Decompiled with CFR 0.152.
 */
package log;

import ghidra.util.Msg;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import utilities.util.reflection.ReflectionUtilities;

@Plugin(name="DevPatternConverter", category="Converter")
@ConverterKeys(value={"hl", "hyperlinker"})
public class Log4jDevelopmentPatternConverter
extends LogEventPatternConverter {
    private static final String TOOL_MESSAGE_SERVICE_CLASSNAME = Msg.class.getName();
    private static final String TOOL_MESSAGE_SERVICE_FILENAME = Msg.class.getSimpleName() + ".java";
    private static final String LOGGER_PACKAGE = ".logging.";
    private static final String PRINT_STACK_TRACE_METHOD_NAME = "printStackTrace";
    private static final MethodPattern[] KNOWN_IGNORE_METHODS = new MethodPattern[]{new MethodPattern("trace"), new MethodPattern("debug"), new MethodPattern("info"), new MethodPattern("warn"), new MethodPattern("error"), new MethodPattern("log"), new MethodPattern("println"), new MethodPattern("printerr"), new MethodPattern("printf")};
    private static final String EMPTY_STRING = "";
    private StringWriter stringWriter = new StringWriter();
    private PrintWriter printWriter = new PrintWriter(this.stringWriter);
    private StringBuilder buffer = new StringBuilder(100);

    protected Log4jDevelopmentPatternConverter(String name, String style) {
        super(name, style);
    }

    public static Log4jDevelopmentPatternConverter newInstance(String[] options) {
        return new Log4jDevelopmentPatternConverter("hyperlinker", "hyperlinker");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String callerInformation = this.getCallerInformation();
        toAppendTo.append(callerInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCallerInformation() {
        Throwable throwable = new Throwable();
        StackTraceElement[] trace = throwable.getStackTrace();
        trace = ReflectionUtilities.movePastStackTracePattern((StackTraceElement[])trace, (String)LOGGER_PACKAGE);
        throwable.setStackTrace(trace);
        String stackString = null;
        StringWriter stringWriter = this.stringWriter;
        synchronized (stringWriter) {
            throwable.printStackTrace(this.printWriter);
            stackString = this.stringWriter.toString();
            this.stringWriter.getBuffer().setLength(0);
        }
        if (stackString.indexOf(PRINT_STACK_TRACE_METHOD_NAME) >= 0) {
            return EMPTY_STRING;
        }
        String cutoffName = this.getHighestLevelMethodNameToIgnore(stackString);
        return this.getLogMessageCallerInformation(trace, cutoffName);
    }

    private String getHighestLevelMethodNameToIgnore(String stackString) {
        String cutoffName = EMPTY_STRING;
        int bestIndex = -1;
        int index = stackString.indexOf(TOOL_MESSAGE_SERVICE_CLASSNAME);
        if (index >= 0) {
            bestIndex = index;
            cutoffName = TOOL_MESSAGE_SERVICE_CLASSNAME;
        }
        for (MethodPattern excludePattern : KNOWN_IGNORE_METHODS) {
            String pattern = excludePattern.getMethodPattern();
            index = stackString.indexOf(pattern);
            if (index < 0 || index < bestIndex) continue;
            bestIndex = index;
            cutoffName = excludePattern.getMethodName();
        }
        return cutoffName;
    }

    private String getLogMessageCallerInformation(StackTraceElement[] trace, String cutoffName) {
        int lastIndexOfCutoffFilename = -1;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            String className = element.getClassName();
            String methodName = element.getMethodName();
            if (!cutoffName.equals(className) && !cutoffName.equals(methodName)) continue;
            lastIndexOfCutoffFilename = i;
        }
        if (++lastIndexOfCutoffFilename >= trace.length) {
            return EMPTY_STRING;
        }
        return this.buildFileInfo(trace[lastIndexOfCutoffFilename]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildFileInfo(StackTraceElement stackTraceElement) {
        String filename = stackTraceElement.getFileName();
        int lineNumber = stackTraceElement.getLineNumber();
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.append(' ').append('(');
            this.buffer.append(filename);
            this.buffer.append(':');
            this.buffer.append(lineNumber);
            this.buffer.append(')');
            String value = this.buffer.toString();
            this.buffer.delete(0, this.buffer.length());
            return value;
        }
    }

    private static class MethodPattern {
        private final String methodName;
        private final String methodPattern;

        MethodPattern(String methodName) {
            this.methodName = methodName;
            this.methodPattern = "." + methodName + "(";
        }

        String getMethodPattern() {
            return this.methodPattern;
        }

        String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.methodPattern;
        }
    }
}

