/*-
 * Copyright (C) 2007-2008 Erik Larsson
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ExtractProgressPanel.java
 *
 * Created on den 3 april 2007, 09:02
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.event.ActionListener;
import org.catacombae.hfsexplorer.*;
import javax.swing.SwingUtilities;
import java.text.DecimalFormat;

/**
 *
 * @author  Erik
 */
public class ExtractProgressPanel extends javax.swing.JPanel {

    private final DecimalFormat progressFormatter = new DecimalFormat("0.0");
    private final DecimalFormat fileSizeFormatter = new DecimalFormat("0.00");

    /** Creates new form ExtractProgressPanel */
    public ExtractProgressPanel() {
        initComponents();
        progressBar.setMinimum(0);
        progressBar.setMaximum(Integer.MAX_VALUE);
    }

    public void updateCalculateDir(final String dirname) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                currentFilenameLabel.setText("Processing: " + dirname);
                currentFilenameLabel.setToolTipText(dirname);
            }
        });
    }

    /** <code>fraction</code> must be between 0 and 1. */
    public void updateTotalProgress(final double fraction, final String message) {
        // just to be sure no deadlocks arise...
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                progressBar.setValue((int) (fraction * Integer.MAX_VALUE));
                progressBar.setString((progressFormatter.format(100 * fraction) + "% (" + message + ")"));
            }
        });
    }

    public void updateCurrentDir(final String dirname) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                currentFilenameLabel.setText("Extracting: " + dirname);
                currentFilenameLabel.setToolTipText(dirname);
            }
        });
    }

    public void updateCurrentFile(final String filename, final long fileSize) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                currentFilenameLabel.setText("Extracting: " + filename + " (" + SpeedUnitUtils.bytesToBinaryUnit(fileSize, fileSizeFormatter) + ")");
                currentFilenameLabel.setToolTipText(filename);
            }
        });
    }
    
    public void addShowSettingsButtonListener(ActionListener al) {
        showSettingsButton.addActionListener(al);
    }
    
    public boolean getShowSettingsButtonSelected() {
        return showSettingsButton.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        internalPanel = new javax.swing.JPanel();
        currentFilenameLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        cancelButton = new javax.swing.JButton();
        showSettingsButton = new javax.swing.JToggleButton();

        currentFilenameLabel.setText("Calculating selection size...");

        progressBar.setString("Calculating selection size...");
        progressBar.setStringPainted(true);

        cancelButton.setText("Cancel");

        showSettingsButton.setText(">>");

        org.jdesktop.layout.GroupLayout internalPanelLayout = new org.jdesktop.layout.GroupLayout(internalPanel);
        internalPanel.setLayout(internalPanelLayout);
        internalPanelLayout.setHorizontalGroup(
            internalPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(currentFilenameLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 400, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(internalPanelLayout.createSequentialGroup()
                .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 274, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(cancelButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(showSettingsButton))
        );
        internalPanelLayout.setVerticalGroup(
            internalPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(internalPanelLayout.createSequentialGroup()
                .add(currentFilenameLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(internalPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(progressBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 24, Short.MAX_VALUE)
                    .add(cancelButton)
                    .add(showSettingsButton)))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(internalPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(internalPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JButton cancelButton;
    private javax.swing.JLabel currentFilenameLabel;
    private javax.swing.JPanel internalPanel;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JToggleButton showSettingsButton;
    // End of variables declaration//GEN-END:variables
}
