/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class MouseListenerTranslator<V, E>
extends MouseAdapter {
    private VisualizationViewer<V, E> vv;
    private GraphMouseListener<V> gel;

    public MouseListenerTranslator(GraphMouseListener<V> gel, VisualizationViewer<V, E> vv) {
        this.gel = gel;
        this.vv = vv;
    }

    private V getVertex(Point2D point) {
        Point2D p = point;
        GraphElementAccessor pickSupport = this.vv.getPickSupport();
        Layout layout = this.vv.getGraphLayout();
        Object v = null;
        if (pickSupport != null) {
            v = pickSupport.getVertex(layout, p.getX(), p.getY());
        }
        return (V)v;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphClicked(v, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphPressed(v, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        V v = this.getVertex(e.getPoint());
        if (v != null) {
            this.gel.graphReleased(v, e);
        }
    }
}

