/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.io;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;
import org.catacombae.io.ReadableRandomAccessStream;

public class ForkFilter
implements ReadableRandomAccessStream {
    private final long forkLength;
    private final CommonHFSExtentDescriptor[] extentDescriptors;
    private final ReadableRandomAccessStream sourceFile;
    private final long fsOffset;
    private final long allocationBlockSize;
    private final long firstBlockByteOffset;
    private long logicalPosition;
    private long lastLogicalPos;
    private long lastPhysicalPos;

    public ForkFilter(CommonHFSForkData forkData, CommonHFSExtentDescriptor[] extentDescriptors, ReadableRandomAccessStream sourceFile, long fsOffset, long allocationBlockSize, long firstBlockByteOffset) {
        this(forkData.getLogicalSize(), extentDescriptors, sourceFile, fsOffset, allocationBlockSize, firstBlockByteOffset);
    }

    public ForkFilter(long forkLength, CommonHFSExtentDescriptor[] extentDescriptors, ReadableRandomAccessStream sourceFile, long fsOffset, long allocationBlockSize, long firstBlockByteOffset) {
        this.forkLength = forkLength;
        this.extentDescriptors = Util.arrayCopy(extentDescriptors, new CommonHFSExtentDescriptor[extentDescriptors.length]);
        this.sourceFile = sourceFile;
        this.fsOffset = fsOffset;
        this.allocationBlockSize = allocationBlockSize;
        this.firstBlockByteOffset = firstBlockByteOffset;
        this.logicalPosition = 0L;
        this.lastLogicalPos = -1L;
        this.lastPhysicalPos = 0L;
    }

    @Deprecated
    public ForkFilter(HFSPlusForkData forkData, HFSPlusExtentDescriptor[] extentDescriptors, ReadableRandomAccessStream sourceFile, long fsOffset, long allocationBlockSize, long firstBlockByteOffset) {
        this.forkLength = forkData.getLogicalSize();
        this.extentDescriptors = new CommonHFSExtentDescriptor[extentDescriptors.length];
        for (int i = 0; i < this.extentDescriptors.length; ++i) {
            this.extentDescriptors[i] = CommonHFSExtentDescriptor.create(extentDescriptors[i]);
        }
        this.sourceFile = sourceFile;
        this.fsOffset = fsOffset;
        this.allocationBlockSize = allocationBlockSize;
        this.firstBlockByteOffset = firstBlockByteOffset;
        this.logicalPosition = 0L;
        this.lastLogicalPos = -1L;
        this.lastPhysicalPos = 0L;
    }

    public void seek(long pos) {
        this.logicalPosition = pos;
    }

    public int read() {
        byte[] oneByte = new byte[1];
        if (this.read(oneByte) == 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int pos, int len) {
        int totalBytesToRead;
        int extIndex;
        long offset = this.fsOffset;
        long bytesToSkip = this.logicalPosition;
        for (extIndex = 0; extIndex < this.extentDescriptors.length; ++extIndex) {
            CommonHFSExtentDescriptor cur = this.extentDescriptors[extIndex];
            long currentExtentLength = cur.getBlockCount() * this.allocationBlockSize;
            if (bytesToSkip >= currentExtentLength) {
                if (extIndex < this.extentDescriptors.length - 1) {
                    bytesToSkip -= currentExtentLength;
                    continue;
                }
                return -1;
            }
            offset = this.fsOffset + this.firstBlockByteOffset + cur.getStartBlock() * this.allocationBlockSize + bytesToSkip;
            break;
        }
        if (this.logicalPosition != this.lastLogicalPos) {
            this.sourceFile.seek(offset);
        } else if (this.sourceFile.getFilePointer() != this.lastPhysicalPos) {
            this.sourceFile.seek(this.lastPhysicalPos);
        }
        long bytesLeftInStream = this.forkLength - this.logicalPosition;
        int bytesLeftToRead = totalBytesToRead = bytesLeftInStream < (long)len ? (int)bytesLeftInStream : len;
        while (extIndex < this.extentDescriptors.length) {
            int bytesReadFromExtent;
            int bytesRead;
            CommonHFSExtentDescriptor cur = this.extentDescriptors[extIndex];
            long bytesInExtent = cur.getBlockCount() * this.allocationBlockSize - bytesToSkip;
            int bytesToReadFromExtent = bytesInExtent < (long)bytesLeftToRead ? (int)bytesInExtent : bytesLeftToRead;
            for (bytesReadFromExtent = 0; bytesReadFromExtent < bytesToReadFromExtent; bytesReadFromExtent += bytesRead) {
                int positionInArray = pos + (totalBytesToRead - bytesLeftToRead) + bytesReadFromExtent;
                int bytesToRead = bytesToReadFromExtent - bytesReadFromExtent;
                bytesRead = this.sourceFile.read(data, positionInArray, bytesToRead);
                if (bytesRead > 0) {
                    continue;
                }
                this.lastPhysicalPos = this.sourceFile.getFilePointer();
                int totalBytesRead = positionInArray - pos;
                this.logicalPosition += (long)totalBytesRead;
                return totalBytesRead;
            }
            bytesToSkip = 0L;
            if ((bytesLeftToRead -= bytesReadFromExtent) == 0) break;
            ++extIndex;
        }
        this.lastPhysicalPos = this.sourceFile.getFilePointer();
        this.logicalPosition += (long)(totalBytesToRead - bytesLeftToRead);
        if (bytesLeftToRead < totalBytesToRead) {
            int bytesRead = totalBytesToRead - bytesLeftToRead;
            return bytesRead;
        }
        return -1;
    }

    public void readFully(byte[] data) {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) {
        int curBytesRead;
        for (int bytesRead = 0; bytesRead < length; bytesRead += curBytesRead) {
            curBytesRead = this.read(data, bytesRead, length - bytesRead);
            if (curBytesRead > 0) {
                continue;
            }
            throw new RuntimeException("Couldn't read the entire length.");
        }
    }

    public long length() {
        return this.forkLength;
    }

    public long getFilePointer() {
        return this.logicalPosition;
    }

    public ReadableRandomAccessStream getUnderlyingStream() {
        return this.sourceFile;
    }

    public void close() {
    }
}

