/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssemblyProcessor
extends CliAbstractTable {
    public CliTableAssemblyProcessor(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliAssemblyProcessorRow(this, reader.readNextInt()));
        }
    }

    @Override
    public DataType getRowDataType() {
        return this.toDataType();
    }

    @Override
    public DataType toDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "AssemblyProcessor Row", 0);
        rowDt.add(DWORD, "Processor", null);
        return new ArrayDataType((DataType)rowDt, this.numRows, rowDt.getLength());
    }

    public class CliAssemblyProcessorRow
    extends CliAbstractTableRow {
        public int processor;

        public CliAssemblyProcessorRow(CliTableAssemblyProcessor this$0, int processor) {
            this.processor = processor;
        }

        @Override
        public String getRepresentation() {
            return String.format("Processor %d", this.processor);
        }
    }
}

