/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.console;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.TextComponentSearcher;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.app.plugin.core.console.ConsoleWord;
import ghidra.app.plugin.core.console.ConsoleWriter;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.GoToService;
import ghidra.app.services.QueryData;
import ghidra.framework.main.ConsoleTextPane;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ConsoleComponentProvider
extends ComponentProviderAdapter
implements ConsoleService {
    private static final String OLD_NAME = "ConsolePlugin";
    private static final String NAME = "Console";
    private static final String DEFAULT_FONT_ID = "font.plugin.console";
    private static final String FONT_OPTION_LABEL = "Font";
    private static final String FONT_DESCRIPTION = "This is the font that will be used in the Console.  Double-click the font example to change it.";
    private ConsoleTextPane textPane;
    private JScrollPane scroller;
    private JComponent component;
    private PrintWriter stderr;
    private PrintWriter stdin;
    private boolean scrollLock = false;
    private DockingAction clearAction;
    private ToggleDockingAction scrollAction;
    private Program currentProgram;
    private Address currentAddress;
    private FindDialog findDialog;
    private TextComponentSearcher searcher;

    public ConsoleComponentProvider(PluginTool tool, String owner) {
        super(tool, NAME, owner);
        ComponentProvider.registerProviderNameOwnerChange((String)OLD_NAME, (String)owner, (String)NAME, (String)owner);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setHelpLocation(new HelpLocation(owner, owner));
        this.setIcon((Icon)new GIcon("icon.plugin.console.provider"));
        this.setWindowMenuGroup(NAME);
        this.setSubTitle("Scripting");
        this.setTitle(NAME);
        this.createOptions();
        this.build();
        this.createActions();
    }

    public boolean canBeParent() {
        return false;
    }

    void init() {
        this.stderr = new PrintWriter(new ConsoleWriter(this, true));
        this.stdin = new PrintWriter(new ConsoleWriter(this, false));
        this.setVisible(true);
    }

    void dispose() {
        this.textPane.dispose();
        this.stderr.close();
        this.stdin.close();
        if (this.findDialog != null) {
            this.findDialog.close();
        }
    }

    private void createOptions() {
        ToolOptions options = this.tool.getOptions(NAME);
        HelpLocation help = new HelpLocation(this.getOwner(), this.getOwner());
        options.registerThemeFontBinding(FONT_OPTION_LABEL, DEFAULT_FONT_ID, help, FONT_DESCRIPTION);
        options.setOptionsHelpLocation(help);
    }

    private void build() {
        this.textPane = new ConsoleTextPane(this.tool);
        Gui.registerFont((Component)this.textPane, (String)DEFAULT_FONT_ID);
        this.textPane.setEditable(false);
        String textPaneName = "Console Text Pane";
        this.textPane.setName(textPaneName);
        this.textPane.getAccessibleContext().setAccessibleName(textPaneName);
        this.textPane.addMouseMotionListener(new CursorUpdateMouseMotionListener());
        this.textPane.addMouseListener(new GoToMouseListener());
        this.scroller = new JScrollPane(this.textPane);
        this.scroller.setPreferredSize(new Dimension(200, 100));
        this.component = new JPanel(new BorderLayout(5, 5));
        this.component.add((Component)this.scroller, "Center");
        this.tool.addComponentProvider((ComponentProvider)this, true);
    }

    private boolean isSymbol(String word) {
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        SymbolIterator symbolIterator = symbolTable.getSymbols(word);
        return symbolIterator.hasNext();
    }

    private void createActions() {
        this.clearAction = new DockingAction("Clear Console", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                ConsoleComponentProvider.this.clearMessages();
            }
        };
        this.clearAction.setDescription("Clear Console");
        this.clearAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.console.clear"), null));
        this.clearAction.setEnabled(true);
        this.scrollAction = new ToggleDockingAction("Scroll Lock", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                ConsoleComponentProvider.this.textPane.setScrollLock(this.isSelected());
            }
        };
        this.scrollAction.setDescription("Scroll Lock");
        this.scrollAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.console.scroll.lock"), null));
        this.scrollAction.setEnabled(true);
        this.scrollAction.setSelected(this.scrollLock);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Find", this.getOwner()).keyBinding("Ctrl F")).sharedKeyBinding()).helpLocation(new HelpLocation(OLD_NAME, "Console_Find"))).popupMenuPath(new String[]{"Find..."})).onAction(c -> this.showFindDialog())).buildAndInstallLocal((ComponentProvider)this);
        this.addLocalAction((DockingActionIf)this.scrollAction);
        this.addLocalAction((DockingActionIf)this.clearAction);
    }

    private void showFindDialog() {
        if (this.findDialog == null) {
            this.searcher = new TextComponentSearcher((JEditorPane)this.textPane);
            this.findDialog = new FindDialog("Find", (FindDialogSearcher)this.searcher);
        }
        this.getTool().showDialog((DialogComponentProvider)this.findDialog);
    }

    @Override
    public void addMessage(String originator, String message) {
        this.checkVisible();
        this.textPane.addMessage(originator + "> " + message + "\n");
    }

    @Override
    public void addErrorMessage(String originator, String message) {
        this.checkVisible();
        this.textPane.addErrorMessage(originator + "> " + message + "\n");
    }

    @Override
    public void addException(String originator, Exception e) {
        Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
    }

    @Override
    public void clearMessages() {
        this.checkVisible();
        this.textPane.setText("");
        if (this.searcher != null) {
            this.searcher.clearHighlights();
        }
    }

    @Override
    public void print(String msg) {
        this.checkVisible();
        this.textPane.addPartialMessage(msg);
    }

    @Override
    public void printError(String errmsg) {
        this.checkVisible();
        this.textPane.addErrorMessage(errmsg);
    }

    @Override
    public void println(String msg) {
        this.checkVisible();
        this.textPane.addMessage(msg + "\n");
    }

    @Override
    public void printlnError(String errmsg) {
        this.checkVisible();
        this.textPane.addErrorMessage(errmsg + "\n");
    }

    @Override
    public PrintWriter getStdErr() {
        return this.stderr;
    }

    @Override
    public PrintWriter getStdOut() {
        return this.stdin;
    }

    @Override
    public String getText(int offset, int length) {
        try {
            return this.textPane.getDocument().getText(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getTextLength() {
        return this.textPane.getDocument().getLength();
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            this.tool.showComponentProvider((ComponentProvider)this, true);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    ConsoleTextPane getTextPane() {
        return this.textPane;
    }

    public void setCurrentProgram(Program program) {
        this.currentProgram = program;
    }

    public void setCurrentAddress(Address address) {
        this.currentAddress = address;
    }

    private static ConsoleWord getWordSeparatedByWhitespace(JTextComponent textComponent, Point p) {
        int pos = textComponent.viewToModel2D(p);
        Document doc = textComponent.getDocument();
        int endIndex = pos;
        try {
            char c;
            int startIndex;
            for (startIndex = pos; startIndex > 0 && !Character.isWhitespace(c = doc.getText(startIndex, 1).charAt(0)); --startIndex) {
            }
            while (endIndex < doc.getLength() - 1 && !Character.isWhitespace(c = doc.getText(endIndex, 1).charAt(0))) {
                ++endIndex;
            }
            String text = doc.getText(startIndex + 1, endIndex - startIndex);
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            return new ConsoleWord(text.trim(), startIndex + 1, endIndex);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private class CursorUpdateMouseMotionListener
    extends MouseMotionAdapter {
        private CursorUpdateMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ConsoleComponentProvider.this.currentProgram == null) {
                return;
            }
            Point hoverPoint = e.getPoint();
            ConsoleWord word = ConsoleComponentProvider.getWordSeparatedByWhitespace(ConsoleComponentProvider.this.textPane, hoverPoint);
            if (word == null) {
                ConsoleComponentProvider.this.textPane.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Address addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(word.word);
            if (addr != null || ConsoleComponentProvider.this.isSymbol(word.word)) {
                ConsoleComponentProvider.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
            addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(trimmedWord.word);
            if (addr != null || ConsoleComponentProvider.this.isSymbol(trimmedWord.word)) {
                ConsoleComponentProvider.this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
        }
    }

    private class GoToMouseListener
    extends MouseAdapter {
        private GoToMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            if (ConsoleComponentProvider.this.currentProgram == null) {
                return;
            }
            GoToService gotoService = (GoToService)ConsoleComponentProvider.this.tool.getService(GoToService.class);
            if (gotoService == null) {
                return;
            }
            Point clickPoint = e.getPoint();
            ConsoleWord word = ConsoleComponentProvider.getWordSeparatedByWhitespace(ConsoleComponentProvider.this.textPane, clickPoint);
            if (word == null) {
                return;
            }
            Address addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(word.word);
            if (addr != null || ConsoleComponentProvider.this.isSymbol(word.word)) {
                this.goTo(word);
                return;
            }
            ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
            addr = ConsoleComponentProvider.this.currentProgram.getAddressFactory().getAddress(trimmedWord.word);
            if (addr == null && !ConsoleComponentProvider.this.isSymbol(trimmedWord.word)) {
                return;
            }
            this.goTo(trimmedWord);
        }

        private void goTo(ConsoleWord word) {
            GoToService gotoService = (GoToService)ConsoleComponentProvider.this.tool.getService(GoToService.class);
            if (gotoService == null) {
                return;
            }
            boolean found = gotoService.goToQuery(ConsoleComponentProvider.this.currentAddress, new QueryData(word.word, true), null, null);
            if (found) {
                this.select(word);
                return;
            }
            ConsoleWord trimmedWord = word.getWordWithoutSpecialCharacters();
            found = gotoService.goToQuery(ConsoleComponentProvider.this.currentAddress, new QueryData(trimmedWord.word, true), null, null);
            if (found) {
                this.select(trimmedWord);
            }
        }

        private void select(ConsoleWord word) {
            try {
                ConsoleComponentProvider.this.textPane.select(word.startPosition, word.endPosition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

