/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.console;

import javax.swing.JComponent;

public class CodeCompletion
implements Comparable<CodeCompletion> {
    private String description;
    private String insertion;
    private JComponent component;
    private int charsToRemove;

    public static boolean isValid(CodeCompletion completion) {
        return completion != null && completion.getInsertion() != null;
    }

    public CodeCompletion(String description, String insertion, JComponent comp) {
        this.description = description;
        this.insertion = insertion;
        this.component = comp;
        this.charsToRemove = 0;
    }

    public CodeCompletion(String description, String insertion, JComponent comp, int charsToRemove) {
        this.description = description;
        this.insertion = insertion;
        this.component = comp;
        this.charsToRemove = charsToRemove;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInsertion() {
        return this.insertion;
    }

    public int getCharsToRemove() {
        return this.charsToRemove;
    }

    public String toString() {
        return "CodeCompletion: '" + this.getDescription() + "' (" + this.getInsertion() + ")";
    }

    @Override
    public int compareTo(CodeCompletion that) {
        return this.description.compareToIgnoreCase(that.description);
    }
}

