/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cpio;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cpio.CpioFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;

@FileSystemInfo(type="cpio", description="CPIO", factory=CpioFileSystemFactory.class)
public class CpioFileSystem
extends AbstractFileSystem<CpioArchiveEntry> {
    private ByteProvider provider;

    public CpioFileSystem(FSRLRoot fsFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException {
        super(fsFSRL, fsService);
        monitor.setMessage("Opening CPIO...");
        this.provider = provider;
        try (CpioArchiveInputStream cpioInputStream2 = new CpioArchiveInputStream(provider.getInputStream(0L));){
            CpioArchiveEntry entry;
            int fileNum = 0;
            while ((entry = cpioInputStream2.getNextCPIOEntry()) != null) {
                FSUtilities.streamCopy((InputStream)cpioInputStream2, (OutputStream)OutputStream.nullOutputStream(), (TaskMonitor)monitor);
                monitor.setMessage(entry.getName());
                this.fsIndex.storeFile(entry.getName(), (long)fileNum++, entry.isDirectory(), entry.getSize(), (Object)entry);
            }
        }
        catch (EOFException cpioInputStream2) {
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        CpioArchiveEntry entry = (CpioArchiveEntry)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.getName());
            result.add(FileAttributeType.SIZE_ATTR, (Object)entry.getSize());
            result.add(FileAttributeType.MODIFIED_DATE_ATTR, (Object)entry.getLastModifiedDate());
            result.add(FileAttributeType.USER_ID_ATTR, (Object)entry.getUID());
            result.add(FileAttributeType.GROUP_ID_ATTR, (Object)entry.getGID());
            result.add("Mode", (Object)Long.toHexString(entry.getMode()));
            result.add("Inode", (Object)Long.toHexString(entry.getInode()));
            result.add("Format", (Object)Long.toHexString(entry.getFormat()));
            try {
                result.add("Device ID", (Object)Long.toHexString(entry.getDevice()));
                result.add("Remote Device", (Object)Long.toHexString(entry.getRemoteDevice()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                result.add("Checksum", (Object)Long.toHexString(entry.getChksum()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        CpioArchiveEntry targetEntry = (CpioArchiveEntry)this.fsIndex.getMetadata(file);
        if (targetEntry == null) {
            return null;
        }
        if (!targetEntry.isRegularFile()) {
            throw new IOException("CPIO entry " + file.getName() + " is not a regular file.");
        }
        try (CpioArchiveInputStream cpioInputStream = new CpioArchiveInputStream(this.provider.getInputStream(0L));){
            CpioArchiveEntry currentEntry;
            while ((currentEntry = cpioInputStream.getNextCPIOEntry()) != null) {
                if (currentEntry.equals((Object)targetEntry)) {
                    ByteProvider bp;
                    ByteProvider byteProvider = bp = this.fsService.getDerivedByteProvider(this.provider.getFSRL(), file.getFSRL(), file.getPath(), currentEntry.getSize(), () -> cpioInputStream, monitor);
                    return byteProvider;
                }
                FSUtilities.streamCopy((InputStream)cpioInputStream, (OutputStream)OutputStream.nullOutputStream(), (TaskMonitor)monitor);
            }
            throw new IOException("Unable to seek to entry: " + file.getName());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }
}

