/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.program.AbstractDBTraceProgramViewListing;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Lifespan;
import ghidra.util.LockHold;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DBTraceProgramViewListing
extends AbstractDBTraceProgramViewListing {
    public DBTraceProgramViewListing(DBTraceProgramView program) {
        super(program, program.trace.getCodeManager());
    }

    public boolean isUndefined(Address start, Address end) {
        try (LockHold hold = this.program.trace.lockRead();){
            for (AddressRange range : this.program.getAddressFactory().getAddressSet(start, end)) {
                for (long s : this.program.viewport.getOrderedSnaps()) {
                    if (this.isUndefinedRange(s, range)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public void clearCodeUnits(Address startAddr, Address endAddr, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = this.program.trace.lockWrite();){
            for (AddressRange range : this.program.getAddressFactory().getAddressSet(startAddr, endAddr)) {
                monitor.checkCancelled();
                this.codeOperations.definedUnits().clear(Lifespan.at(this.program.snap), range, clearContext, monitor);
            }
        }
    }

    public void clearAll(boolean clearContext, TaskMonitor monitor) {
        try (LockHold hold = this.program.trace.lockRead();){
            for (AddressRange range : this.program.getAddressFactory().getAddressSet()) {
                this.codeOperations.definedUnits().clear(Lifespan.at(this.program.snap), range, clearContext, monitor);
            }
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }
}

