/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.app.util.pdb.classtype.VirtualBaseTableEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.List;

public class ProgramVirtualBaseTable
extends VirtualBaseTable {
    private Program program;
    private Address address;
    private int entrySize;
    private String mangledName;

    public ProgramVirtualBaseTable(ClassID owner, List<ClassID> parentage, Program program, Address address, int entrySize, String mangledName) {
        super(owner, parentage);
        this.program = program;
        this.address = address;
        this.entrySize = entrySize;
        this.mangledName = mangledName;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getMangledName() {
        return this.mangledName;
    }

    @Override
    public Long getBaseOffset(int tableIndex) throws PdbException {
        Long offset = (Long)this.baseOffsetByTableIndex.get(tableIndex);
        if (offset != null) {
            return offset;
        }
        offset = this.getOffsetFromMemory(tableIndex);
        if (offset != null) {
            this.baseOffsetByTableIndex.put(tableIndex, offset);
        }
        return offset;
    }

    private Long getOffsetFromMemory(int tableIndex) throws PdbException {
        if (this.program == null || this.address == null) {
            return null;
        }
        Memory memory = this.program.getMemory();
        Address entryAddress = this.address.add((long)(tableIndex * this.entrySize));
        try {
            Long offset;
            Long l = offset = Long.valueOf(this.entrySize == 4 ? (long)memory.getInt(entryAddress) : memory.getLong(entryAddress));
            return l;
        }
        catch (MemoryAccessException e) {
            throw new PdbException("MemoryAccessException while trying to parse virtual base table entry at address: " + String.valueOf(entryAddress));
        }
        finally {
            this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
        }
    }

    @Override
    protected VirtualBaseTableEntry getNewEntry(ClassID baseId) {
        return new VirtualBaseTableEntry(baseId);
    }

    private VirtualBaseTableEntry entry(int tableIndex) {
        return (VirtualBaseTableEntry)this.entryByTableIndex.get(tableIndex);
    }

    private VirtualBaseTableEntry existing(int tableIndex) throws PdbException {
        VirtualBaseTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            throw new PdbException("No entry in Virtual Base Table for table offset: " + tableIndex);
        }
        return entry;
    }
}

