/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StringIdMsType;
import java.util.ArrayList;
import java.util.List;

public class SubstringListMsType
extends AbstractMsType {
    public static final int PDB_ID = 5636;
    protected List<RecordNumber> recordNumbers = new ArrayList<RecordNumber>();

    public SubstringListMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        int count = reader.parseInt();
        for (int i = 0; i < count; ++i) {
            RecordNumber aRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
            this.recordNumbers.add(aRecordNumber);
        }
    }

    public List<RecordNumber> getList() {
        return this.recordNumbers;
    }

    @Override
    public int getPdbId() {
        return 5636;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        for (RecordNumber aRecordNumber : this.recordNumbers) {
            AbstractMsType type = this.pdb.getTypeRecord(aRecordNumber);
            if (!(type instanceof StringIdMsType)) {
                return;
            }
            builder.append(type);
        }
    }
}

