/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JTreeMouseListenerDelegate
extends MouseAdapter {
    private final Set<MouseListener> listeners = new CopyOnWriteArraySet<MouseListener>();
    private final JTree tree;
    private boolean consumedPressed;

    public JTreeMouseListenerDelegate(JTree tree) {
        this.tree = tree;
        this.installMouseListenerDelegate();
        tree.addMouseListener(this);
    }

    private void installMouseListenerDelegate() {
        MouseListener[] mouseListeners = this.tree.getMouseListeners();
        List<MouseListener> list = Arrays.asList(mouseListeners);
        this.listeners.addAll(list);
        for (MouseListener listener : mouseListeners) {
            this.tree.removeMouseListener(listener);
        }
    }

    public MouseListener[] getMouseListeners() {
        if (this.listeners.isEmpty()) {
            return new MouseListener[0];
        }
        return this.listeners.toArray(new MouseListener[this.listeners.size()]);
    }

    public void addMouseListener(MouseListener listener) {
        this.listeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.listeners.remove(listener);
    }

    public void addMouseListeners(List<MouseListener> listenerList) {
        this.listeners.addAll(listenerList);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener listener : this.listeners) {
            listener.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener listener : this.listeners) {
            listener.mouseExited(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopupTrigger(e);
        if (this.isPotentialDragSelection(e)) {
            e.consume();
            this.consumedPressed = true;
            this.fixFocus();
        } else {
            this.consumedPressed = false;
        }
        this.fireMousePressed(e);
    }

    private void fixFocus() {
        if (!this.tree.hasFocus()) {
            this.tree.requestFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handlePopupTrigger(e);
        this.fireMouseClicked(e);
        this.consumedPressed = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.handlePopupTrigger(e)) {
            this.maybeResetSelectionPath(e);
        }
        this.fireMouseReleased(e);
    }

    protected void fireMousePressed(MouseEvent e) {
        for (MouseListener listener : this.listeners) {
            listener.mousePressed(e);
        }
    }

    protected void fireMouseClicked(MouseEvent e) {
        for (MouseListener listener : this.listeners) {
            listener.mouseClicked(e);
        }
    }

    protected void fireMouseReleased(MouseEvent e) {
        for (MouseListener listener : this.listeners) {
            listener.mouseReleased(e);
        }
    }

    protected boolean handlePopupTrigger(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return false;
        }
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath != null && !this.tree.isPathSelected(selPath)) {
            this.setSelectedPathNow(selPath);
        }
        return true;
    }

    private void maybeResetSelectionPath(MouseEvent e) {
        if (!this.consumedPressed) {
            return;
        }
        TreePath clickedPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (clickedPath == null) {
            return;
        }
        this.setSelectedPathNow(clickedPath);
    }

    protected boolean isPotentialDragSelection(MouseEvent e) {
        if (e.getButton() == 1) {
            if (e.getClickCount() > 1) {
                return false;
            }
            if (e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown()) {
                return false;
            }
            TreePath selectionPath = this.tree.getPathForLocation(e.getX(), e.getY());
            if (selectionPath == null) {
                return false;
            }
            if (this.tree.isPathSelected(selectionPath)) {
                return true;
            }
        }
        return false;
    }

    protected void setSelectedPathNow(TreePath path) {
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.setSelectionPath(path);
    }
}

