/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.DockingWindowManager;
import docking.ReusableDialogComponentProvider;
import generic.theme.ThemeValue;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class ThemeValueEditor<T> {
    private PropertyChangeListener clientListener;
    protected ThemeValue<T> currentThemeValue;
    private EditorDialog dialog;
    private String typeName;
    protected PropertyEditor editor;

    protected ThemeValueEditor(String typeName, PropertyChangeListener listener, PropertyEditor editor) {
        this.typeName = typeName;
        this.clientListener = listener;
        this.editor = editor;
    }

    public void editValue(ThemeValue<T> themeValue) {
        this.currentThemeValue = themeValue;
        if (this.dialog == null) {
            this.dialog = new EditorDialog(themeValue);
            DockingWindowManager.showDialog(this.dialog);
        } else {
            this.dialog.setValue(themeValue);
            this.dialog.toFront();
        }
    }

    protected void storeState() {
    }

    protected abstract T getRawValue(String var1);

    protected abstract ThemeValue<T> createNewThemeValue(String var1, T var2);

    private void valueChanged(T value) {
        ThemeValue<T> oldValue = this.currentThemeValue;
        String id = oldValue.getId();
        ThemeValue<T> newValue = this.createNewThemeValue(id, value);
        this.firePropertyChangeEvent(oldValue, newValue);
        PropertyChangeEvent event = new PropertyChangeEvent(this, id, oldValue, newValue);
        this.clientListener.propertyChange(event);
    }

    private void firePropertyChangeEvent(ThemeValue<T> oldValue, ThemeValue<T> newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, oldValue.getId(), oldValue, newValue);
        this.clientListener.propertyChange(event);
    }

    class EditorDialog
    extends ReusableDialogComponentProvider {
        private PropertyChangeListener internalListener;
        private ThemeValue<T> originalValue;

        protected EditorDialog(ThemeValue<T> initialValue) {
            super("Edit " + ThemeValueEditor.this.typeName + ": " + ThemeValueEditor.this.currentThemeValue.getId(), false, false, true, false);
            this.internalListener = ev -> this.editorChanged();
            this.originalValue = initialValue;
            this.addWorkPanel(this.buildWorkPanel(ThemeValueEditor.this.getRawValue(initialValue.getId())));
            this.addOKButton();
            this.addCancelButton();
            this.setRememberSize(false);
        }

        private void editorChanged() {
            ThemeValueEditor.this.valueChanged(ThemeValueEditor.this.editor.getValue());
        }

        JComponent buildWorkPanel(T initialValue) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            panel.add(ThemeValueEditor.this.editor.getCustomEditor(), "Center");
            ThemeValueEditor.this.editor.setValue(initialValue);
            ThemeValueEditor.this.storeState();
            ThemeValueEditor.this.editor.addPropertyChangeListener(this.internalListener);
            return panel;
        }

        void setValue(ThemeValue<T> value) {
            this.originalValue = value;
            ThemeValueEditor.this.editor.removePropertyChangeListener(this.internalListener);
            ThemeValueEditor.this.editor.setValue(ThemeValueEditor.this.getRawValue(value.getId()));
            ThemeValueEditor.this.editor.addPropertyChangeListener(this.internalListener);
        }

        @Override
        protected void okCallback() {
            this.close();
            ThemeValueEditor.this.storeState();
            ThemeValueEditor.this.dialog = null;
        }

        @Override
        protected void cancelCallback() {
            ThemeValueEditor.this.firePropertyChangeEvent(ThemeValueEditor.this.currentThemeValue, this.originalValue);
            this.close();
            ThemeValueEditor.this.dialog = null;
        }
    }
}

