/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Iterator;
import java.util.List;

class FontShorthandSetter
extends ShorthandSetter {
    private boolean lineHeightSet = false;

    FontShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "font");
    }

    @Override
    protected List<String> subpropertyList() {
        List<String> subp = super.subpropertyList();
        subp.remove("line-height");
        subp.remove("font-kerning");
        subp.remove("font-optical-sizing");
        subp.remove("font-feature-settings");
        subp.remove("font-variation-settings");
        subp.remove("font-size-adjust");
        subp.add(0, "font-variant-css21");
        return subp;
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        shorthandValue = this.filterNormalIdentifier(shorthandValue);
        super.init(shorthandValue, important);
    }

    @Override
    public short assignSubproperties() {
        if (this.currentValue == null) {
            List<String> subp = super.subpropertyList();
            Iterator<String> it = subp.iterator();
            while (it.hasNext()) {
                this.addUnassignedProperty(it.next());
            }
            this.resetSubproperties();
            this.flush();
            this.getValueItemBuffer().append("normal");
            this.getValueItemBufferMini().append("normal");
            return 0;
        }
        short result = this.draftSubproperties();
        if (result == 0) {
            if (this.getUnassignedProperties().contains("font-family")) {
                if (!this.getUnassignedProperties().contains("font-size")) {
                    this.reportMissingPropertySyntaxError("font-family");
                    return 2;
                }
                if (!this.getUnassignedProperties().contains("font-stretch")) {
                    this.reportMissingPropertySyntaxError("font-family");
                    return 2;
                }
            } else if (this.getUnassignedProperties().contains("font-size")) {
                this.reportMissingPropertySyntaxError("font-size");
                return 2;
            }
            this.flush();
            return 0;
        }
        return result;
    }

    private void reportMissingPropertySyntaxError(String missedProperty) {
        StringBuilder sb = new StringBuilder(this.getValueItemBuffer().length() + missedProperty.length() + 40);
        sb.append("This syntax requires ");
        sb.append(missedProperty);
        sb.append(" to be present: ");
        sb.append((CharSequence)this.getValueItemBuffer());
        this.reportDeclarationError("font", sb.toString());
    }

    @Override
    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.filterNormalIdentifier(this.currentValue.getNextLexicalUnit());
            this.appendValueItemString();
        }
    }

    private LexicalUnit filterNormalIdentifier(LexicalUnit lu) {
        while (lu != null && lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "normal".equalsIgnoreCase(lu.getStringValue())) {
            lu = lu.getNextLexicalUnit();
        }
        return lu;
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        if (subproperty.equals("font-size") && this.assignFontSize()) {
            if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                this.nextCurrentValue();
                StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setProperty("line-height", cssValue, this.isPriorityImportant());
                this.nextCurrentValue();
                this.lineHeightSet = true;
            }
            return true;
        }
        switch (this.currentValue.getLexicalUnitType()) {
            case IDENT: {
                if (subproperty.equals("font-variant-css21")) {
                    if (!"small-caps".equalsIgnoreCase(this.currentValue.getStringValue())) break;
                    this.setSubpropertyValue("font-variant-caps", this.createCSSValue("font-variant-caps", this.currentValue));
                    this.nextCurrentValue();
                    return true;
                }
                if (super.assignSubproperty(subproperty)) {
                    return true;
                }
                if (!subproperty.equals("font-family")) break;
                this.consumeFontFamilyIdent();
                while (this.currentValue != null) {
                    LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
                    if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMSyntaxException("Unexpected comma at the end of font-family list");
                        }
                        type = this.currentValue.getLexicalUnitType();
                    }
                    if (type == LexicalUnit.LexicalType.IDENT) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (type != LexicalUnit.LexicalType.STRING) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case STRING: {
                if (!subproperty.equals("font-family")) break;
                this.consumeFontFamilyString();
                while (this.currentValue != null) {
                    LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
                    if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMSyntaxException("Unexpected comma at the end of font-family list");
                        }
                        type = this.currentValue.getLexicalUnitType();
                    }
                    if (type == LexicalUnit.LexicalType.IDENT) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (type != LexicalUnit.LexicalType.STRING) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case INTEGER: {
                if (!subproperty.equals("font-weight")) break;
                this.setSubpropertyValue("font-weight", this.createCSSValue("font-size", this.currentValue));
                this.nextCurrentValue();
                return true;
            }
        }
        return false;
    }

    private void consumeFontFamilyIdent() {
        CSSValue.Type stringType = CSSValue.Type.IDENT;
        String str = this.currentValue.getStringValue();
        super.nextCurrentValue();
        while (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            String s = this.currentValue.getStringValue();
            str = str + " " + s;
            stringType = CSSValue.Type.STRING;
            super.nextCurrentValue();
        }
        AbstractTextValue value = stringType == CSSValue.Type.STRING ? new StringValue() : new IdentifierValue();
        value.setStringValue(stringType, str);
        value.setSubproperty(true);
        this.addSubpropertyValue("font-family", value, true);
    }

    private void consumeFontFamilyString() {
        StyleValue value = this.createCSSValue("font-family", this.currentValue);
        this.addSubpropertyValue("font-family", value, true);
        super.nextCurrentValue();
    }

    private boolean assignFontSize() {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            return super.assignSubproperty("font-size");
        }
        if (ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
            StyleValue cssValue = this.createCSSValue("font-size", this.currentValue);
            this.setSubpropertyValue("font-size", cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void resetSubproperties() {
        this.getUnassignedProperties().remove("font-variant-css21");
        super.resetSubproperties();
        if (!this.lineHeightSet) {
            this.setPropertyToDefault("line-height");
        }
        if (!this.isPropertySet("font-variant-caps")) {
            this.setPropertyToDefault("font-variant-caps");
        }
        this.setPropertyToDefault("font-size-adjust");
        this.setPropertyToDefault("font-kerning");
        this.setPropertyToDefault("font-optical-sizing");
        this.setPropertyToDefault("font-feature-settings");
        this.setPropertyToDefault("font-variation-settings");
        this.setPropertyToDefault("font-variant-ligatures");
        this.setPropertyToDefault("font-variant-position");
        this.setPropertyToDefault("font-variant-numeric");
        this.setPropertyToDefault("font-variant-alternates");
        this.setPropertyToDefault("font-variant-east-asian");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        this.getUnassignedProperties().remove("font-variant-css21");
        super.setSubpropertiesToKeyword(keyword);
        this.lineHeightSet = true;
        this.setProperty("line-height", keyword, this.isPriorityImportant());
        this.setProperty("font-kerning", keyword, this.isPriorityImportant());
        this.setProperty("font-optical-sizing", keyword, this.isPriorityImportant());
        this.setProperty("font-feature-settings", keyword, this.isPriorityImportant());
        this.setProperty("font-variation-settings", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-ligatures", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-position", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-caps", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-numeric", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-alternates", keyword, this.isPriorityImportant());
        this.setProperty("font-variant-east-asian", keyword, this.isPriorityImportant());
        this.flush();
    }
}

