/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.parser.BufferTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSContentHandler;
import io.sf.carte.doc.style.css.parser.CSSTokenHandler;
import io.sf.carte.doc.style.css.parser.HandlerManager;
import io.sf.carte.doc.style.css.parser.ValueTokenHandler;

abstract class CallbackTokenHandler
extends BufferTokenHandler {
    final CSSContentHandler caller;
    private CSSContentHandler rootHandler;

    CallbackTokenHandler(CSSContentHandler caller) {
        this.caller = caller;
        this.rootHandler = caller;
    }

    protected CSSContentHandler getCaller() {
        return this.caller;
    }

    CSSContentHandler getRootHandler() {
        return this.rootHandler;
    }

    void setRootHandler(CSSContentHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public void leftParenthesis(int index) {
        this.incrParenDepth();
        this.unexpectedCharError(index, 40);
    }

    @Override
    public void rightParenthesis(int index) {
        this.processBuffer(index, 41);
        this.caller.rightParenthesis(index);
    }

    @Override
    public void rightSquareBracket(int index) {
        this.processBuffer(index, 93);
        this.caller.rightSquareBracket(index);
    }

    @Override
    public void rightCurlyBracket(int index) {
        this.processBuffer(index, 41);
        this.caller.rightCurlyBracket(index);
    }

    public void character(int index, int codePoint) {
        if (codePoint == 59) {
            this.handleSemicolon(index);
        } else {
            this.unexpectedCharError(index, codePoint);
        }
    }

    void handleSemicolon(int index) {
        this.processBuffer(index, 59);
        this.caller.character(index, 59);
    }

    @Override
    public void handleErrorRecovery() {
        this.yieldHandling(new CallbackIgnoredDeclarationTH());
    }

    @Override
    public void setParseError() {
        super.setParseError();
        this.caller.setParseError();
    }

    @Override
    public void endOfStream(int len) {
        this.processBuffer(len, 0);
        CSSTokenHandler cur = this.getControlHandler().getCurrentHandler();
        if (cur != this) {
            cur.endOfStream(len);
        } else {
            this.caller.endOfStream(len);
        }
    }

    @Override
    public CSSErrorHandler getErrorHandler() {
        return this.rootHandler.getErrorHandler();
    }

    @Override
    public HandlerManager getManager() {
        return this.rootHandler.getManager();
    }

    void yieldHandling(CallbackTokenHandler yieldHandler) {
        yieldHandler.setRootHandler(this.rootHandler);
        super.yieldHandling(yieldHandler);
    }

    void yieldBack() {
        super.yieldHandling(this.caller);
    }

    private class CallbackIgnoredDeclarationTH
    extends BufferTokenHandler.IgnoredDeclarationTokenHandler {
        CallbackIgnoredDeclarationTH() {
        }

        @Override
        public void resetHandler() {
            CallbackTokenHandler.this.rootHandler.resetHandler();
            CallbackTokenHandler.this.rootHandler.resetParseError();
        }
    }

    class CallbackValueTokenHandler
    extends ValueTokenHandler {
        CallbackValueTokenHandler() {
            this.parendepth = CallbackTokenHandler.this.parendepth;
        }

        @Override
        public void endFunctionArgument(int index) {
            super.endFunctionArgument(index);
            this.checkFunctionCallback(index);
        }

        protected void checkFunctionCallback(int index) {
            if (!this.functionToken && !this.isInError()) {
                CallbackTokenHandler.this.rightParenthesis(index);
            }
        }

        @Override
        public void handleErrorRecovery() {
            CallbackTokenHandler.this.handleErrorRecovery();
        }

        @Override
        public boolean isInError() {
            return CallbackTokenHandler.this.isInError();
        }

        @Override
        public void reportError(CSSParseException ex) throws CSSParseException {
            CallbackTokenHandler.this.reportError(ex);
        }

        @Override
        protected void handleError(CSSParseException ex) throws CSSParseException {
            CallbackTokenHandler.this.handleError(ex);
        }

        @Override
        public CSSErrorHandler getErrorHandler() {
            return CallbackTokenHandler.this.getErrorHandler();
        }

        @Override
        public HandlerManager getManager() {
            return CallbackTokenHandler.this.getManager();
        }
    }
}

