/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AllPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.freeplane.main.application.SortedProperties;

class ApplicationPropertyStore {
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    private final File autoPropertiesFile;
    private final File secretsPropertiesFile;
    private final Properties defProps;
    private final Properties props;
    private final Properties secretsProps;
    private final Properties securedProps;
    private final Set<String> securedForReadingPropertyKeys;
    private final Set<String> persistedInSecretsFilePropertyKeys;
    private final Properties unsecuredPropertiesView;
    private final boolean hasLoadedAutoProperties;
    private final boolean hasLoadedSecretsProperties;

    ApplicationPropertyStore(Properties defaultProperties, File autoPropertiesFile, File secretsPropertiesFile) {
        this.autoPropertiesFile = autoPropertiesFile;
        this.secretsPropertiesFile = secretsPropertiesFile;
        this.defProps = defaultProperties;
        this.props = new SortedProperties(this.defProps);
        this.hasLoadedAutoProperties = this.loadUserProperties(this.props, this.autoPropertiesFile);
        this.secretsProps = new SortedProperties(this.props);
        this.hasLoadedSecretsProperties = this.loadUserProperties(this.secretsProps, this.secretsPropertiesFile);
        this.securedProps = new Properties(this.secretsProps);
        this.securedForReadingPropertyKeys = new HashSet<String>();
        this.persistedInSecretsFilePropertyKeys = new HashSet<String>();
        this.unsecuredPropertiesView = new JoinedPropertiesView();
    }

    boolean hasLoadedAutoProperties() {
        return this.hasLoadedAutoProperties;
    }

    boolean hasLoadedSecretsProperties() {
        return this.hasLoadedSecretsProperties;
    }

    void replacePropertyKey(String oldKey, String newKey) {
        this.replacePropertyKey(this.props, oldKey, newKey);
        this.replacePropertyKey(this.secretsProps, oldKey, newKey);
    }

    String getDefaultProperty(String key) {
        return this.defProps.getProperty(key);
    }

    void setDefaultProperty(String key, String value) {
        this.defProps.setProperty(key, value);
    }

    Properties getUnsecuredProperties() {
        return this.unsecuredPropertiesView;
    }

    String getProperty(String key) {
        if (this.securedForReadingPropertyKeys.contains(key)) {
            ApplicationPropertyStore.checkSecurityPermission();
        }
        return this.securedProps.getProperty(key);
    }

    String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    void setProperty(String key, String value) {
        if (this.securedProps.containsKey(key)) {
            ApplicationPropertyStore.checkSecurityPermission();
            this.securedProps.setProperty(key, value);
        }
        if (this.persistedInSecretsFilePropertyKeys.contains(key)) {
            this.secretsProps.setProperty(key, value);
            this.props.remove(key);
        } else {
            this.props.setProperty(key, value);
        }
    }

    void saveProperties(String freeplaneVersion) {
        OutputStreamWriter outputStreamWriter;
        FileOutputStream out2;
        try {
            out2 = new FileOutputStream(this.autoPropertiesFile);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)out2, "8859_1");
                outputStreamWriter.write("#Freeplane ");
                outputStreamWriter.write(freeplaneVersion);
                outputStreamWriter.write(10);
                outputStreamWriter.flush();
                this.props.store(out2, null);
            }
            finally {
                ((OutputStream)out2).close();
            }
        }
        catch (Exception out2) {
            // empty catch block
        }
        try {
            out2 = new FileOutputStream(this.secretsPropertiesFile);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)out2, "8859_1");
                outputStreamWriter.write("#Freeplane ");
                outputStreamWriter.write(freeplaneVersion);
                outputStreamWriter.write(10);
                outputStreamWriter.flush();
                this.secretsProps.store(out2, null);
            }
            finally {
                ((OutputStream)out2).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Properties getSecuredProperties() {
        ApplicationPropertyStore.checkSecurityPermission();
        return this.securedProps;
    }

    void securePropertyForModification(String key) {
        String propertyValue;
        ApplicationPropertyStore.checkSecurityPermission();
        if (!this.securedProps.containsKey(key) && (propertyValue = this.getProperty(key)) != null) {
            this.securedProps.setProperty(key, propertyValue);
        }
    }

    void securePropertyForReadingAndModification(String key) {
        this.securePropertyForModification(key);
        this.securedForReadingPropertyKeys.add(key);
    }

    void persistPropertyInSecretsFile(String key) {
        if (this.props.containsKey(key)) {
            ApplicationPropertyStore.checkSecurityPermission();
            String value = this.props.getProperty(key);
            if (value != null) {
                this.secretsProps.setProperty(key, value);
            }
            this.props.remove(key);
        }
        this.persistedInSecretsFilePropertyKeys.add(key);
    }

    boolean isPropertySetByUser(String key) {
        return this.props.containsKey(key) || this.secretsProps.containsKey(key);
    }

    private boolean loadUserProperties(Properties target, File file) {
        boolean bl;
        FileInputStream in = new FileInputStream(file);
        try {
            target.load(in);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return false;
            }
        }
        ((InputStream)in).close();
        return bl;
    }

    private void replacePropertyKey(Properties sourceProperties, String oldKey, String newKey) {
        if (sourceProperties.containsKey(oldKey) && !sourceProperties.containsKey(newKey)) {
            sourceProperties.put(newKey, sourceProperties.getProperty(oldKey));
        }
    }

    private boolean isUnsecuredKey(String key) {
        return !this.securedForReadingPropertyKeys.contains(key);
    }

    private String getUnsecuredProperty(String key) {
        if (!this.isUnsecuredKey(key)) {
            return null;
        }
        return this.secretsProps.getProperty(key);
    }

    private Set<String> unsecuredKeys() {
        TreeSet<String> keys = new TreeSet<String>();
        for (Object key : this.props.keySet()) {
            keys.add((String)key);
        }
        for (Object key : this.secretsProps.keySet()) {
            keys.add((String)key);
        }
        keys.removeAll(this.securedForReadingPropertyKeys);
        return keys;
    }

    private Object putUnsecuredProperty(String key, String value) {
        String oldValue = this.getUnsecuredProperty(key);
        this.setProperty(key, value);
        return oldValue;
    }

    private Object removeUnsecuredProperty(String key) {
        String oldValue = this.getUnsecuredProperty(key);
        if (this.persistedInSecretsFilePropertyKeys.contains(key)) {
            this.secretsProps.remove(key);
        } else {
            this.props.remove(key);
            this.secretsProps.remove(key);
        }
        this.securedProps.remove(key);
        return oldValue;
    }

    private static void checkSecurityPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ALL_PERMISSION);
        }
    }

    private class JoinedPropertiesView
    extends Properties {
        private static final long serialVersionUID = 1L;

        private JoinedPropertiesView() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet(ApplicationPropertyStore.this.unsecuredKeys()));
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            for (String key : ApplicationPropertyStore.this.unsecuredKeys()) {
                entries.put(key, ApplicationPropertyStore.this.getUnsecuredProperty(key));
            }
            return entries.entrySet();
        }

        @Override
        public String getProperty(String key) {
            return ApplicationPropertyStore.this.getUnsecuredProperty(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            String value = this.getProperty(key);
            return value != null ? value : defaultValue;
        }

        @Override
        public synchronized Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            return ApplicationPropertyStore.this.getUnsecuredProperty((String)key);
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            String propertyKey = (String)key;
            return ApplicationPropertyStore.this.isUnsecuredKey(propertyKey) && (ApplicationPropertyStore.this.props.containsKey(propertyKey) || ApplicationPropertyStore.this.secretsProps.containsKey(propertyKey));
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            return ApplicationPropertyStore.this.putUnsecuredProperty((String)key, (String)value);
        }

        @Override
        public synchronized Object remove(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            return ApplicationPropertyStore.this.removeUnsecuredProperty((String)key);
        }

        @Override
        public Set<String> stringPropertyNames() {
            return ApplicationPropertyStore.this.unsecuredKeys();
        }

        @Override
        public synchronized Enumeration<?> propertyNames() {
            return Collections.enumeration(ApplicationPropertyStore.this.unsecuredKeys());
        }
    }
}

