/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.DesktopNavigatorModel;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorResourceListener
implements IResourceChangeListener {
    private static final Log log = Log.getLog(NavigatorResourceListener.class);
    private final DesktopNavigatorModel model;

    public NavigatorResourceListener(DesktopNavigatorModel model) {
        this.model = model;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            for (IResourceDelta childDelta : delta.getAffectedChildren()) {
                Object projectMeta;
                IResource iResource = childDelta.getResource();
                if (!(iResource instanceof IProject)) continue;
                IProject project = (IProject)iResource;
                DBNProject projectNode = NavigatorResources.getProjectNode(this.model.getRoot(), project);
                if (projectNode == null) {
                    if (childDelta.getKind() == 1) {
                        projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                        if (projectMeta == null) {
                            log.error((Object)("Can't find project '" + project.getName() + "' metadata"));
                            continue;
                        }
                        this.model.getRoot().addProject(projectMeta, true);
                        continue;
                    }
                    if (childDelta.getKind() == 2) continue;
                    log.error((Object)("Project '" + childDelta.getResource().getName() + "' not found in navigator"));
                    continue;
                }
                if (childDelta.getKind() == 2) {
                    projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
                    if (projectMeta == null) {
                        log.error((Object)("Can't find project '" + project.getName() + "' metadata"));
                        continue;
                    }
                    this.model.getRoot().removeProject(projectMeta);
                    continue;
                }
                this.handleResourceChange((DBNNode)projectNode, childDelta);
            }
        }
    }

    public void refreshResourceState(DBNNode node, Object source) {
        if (node instanceof DBNResource) {
            DBNResource resourceNode = (DBNResource)node;
            DBPResourceHandler newHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resourceNode.getResource());
            if (newHandler != resourceNode.getHandler()) {
                resourceNode.setHandler(newHandler);
            }
            this.model.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, node));
        }
    }

    public void handleResourceChange(DBNNode node, IResourceDelta delta) {
        DBNLazyNode lazyNode;
        if (delta.getKind() == 4) {
            this.refreshResourceState(node, delta);
        }
        if (node instanceof DBNLazyNode && (lazyNode = (DBNLazyNode)node).needsInitialization()) {
            return;
        }
        for (IResourceDelta childDelta : delta.getAffectedChildren(31, 8)) {
            this.handleChildResourceChange(node, childDelta);
        }
    }

    public void handleChildResourceChange(DBNNode parentNode, IResourceDelta delta) {
        DBNNodeWithCache nodeWithCache;
        DBNProject project;
        if (parentNode instanceof DBNProject && this.handleProjectChanges(project = (DBNProject)parentNode, delta)) {
            return;
        }
        if (!(parentNode instanceof DBNNodeWithCache) || (nodeWithCache = (DBNNodeWithCache)parentNode).needsInitialization()) {
            return;
        }
        IResource deltaResource = delta.getResource();
        DBNNode childResource = NavigatorResources.getChild(parentNode, deltaResource);
        if (childResource == null) {
            DBNNode newChild;
            if ((delta.getKind() == 1 || delta.getKind() == 4) && (newChild = NavigatorResources.getChild(parentNode, deltaResource)) == null && (newChild = NavigatorResources.makeNode(parentNode, deltaResource)) != null) {
                Object[] children = nodeWithCache.getCachedChildren();
                children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])children, (Object)newChild);
                NavigatorResources.sortChildren((DBNNode[])children);
                nodeWithCache.setCachedChildren((DBNNode[])children);
                this.model.fireNodeEvent(new DBNEvent((Object)delta, DBNEvent.Action.ADD, newChild));
                if (delta.getKind() == 4 && (childResource = NavigatorResources.getChild(parentNode, deltaResource)) != null) {
                    this.handleResourceChange(childResource, delta);
                }
            }
        } else if (delta.getKind() == 2) {
            Object[] children = nodeWithCache.getCachedChildren();
            children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])children, (Object)childResource);
            nodeWithCache.setCachedChildren((DBNNode[])children);
            DBNUtils.disposeNode((DBNNode)childResource, (boolean)true);
        } else {
            this.handleResourceChange(childResource, delta);
        }
    }

    private boolean handleProjectChanges(DBNProject projectNode, IResourceDelta delta) {
        String name;
        IResourceDelta[] iResourceDeltaArray = projectNode.getProject();
        if (iResourceDeltaArray instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)iResourceDeltaArray;
            if (CommonUtils.equalObjects((Object)delta.getResource(), (Object)rcpProject.getRootResource())) {
                for (IResourceDelta cChild : delta.getAffectedChildren()) {
                    this.handleChildResourceChange((DBNNode)projectNode, cChild);
                }
                return true;
            }
        }
        if ((name = delta.getResource().getName()).equals(".dbeaver")) {
            IResourceDelta[] configFiles = delta.getAffectedChildren();
            boolean dsChanged = false;
            if (configFiles != null) {
                for (IResourceDelta rd : configFiles) {
                    IResource childRes = rd.getResource();
                    if (!(childRes instanceof IFile) || !childRes.getName().startsWith("data-sources")) continue;
                    dsChanged = true;
                }
            }
            if (dsChanged) {
                projectNode.getDatabases().getDataSourceRegistry().refreshConfig();
            }
            return true;
        }
        return false;
    }
}

