/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class CubridConnectionExtraPage
extends ConnectionPageAbstract {
    private static final String PROP_SHARD_TYPE = "shardType";
    private static final String PROP_SHARD_VALUE = "shardValue";
    private static final String PROP_IS_SHARD = "isShard";
    private static final String SHARD_TYPE_ID = "SHARD ID";
    private static final String SHARD_TYPE_VAL = "SHARD VAL";
    private static final String DEFAULT_SHARD_VALUE = "0";
    private Combo shardTypeCombo;
    private Text shardVal;

    public CubridConnectionExtraPage() {
        this.setTitle(CubridMessages.dialog_connection_cubrid_properties);
        this.setDescription(CubridMessages.dialog_connection_cubrid_properties_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        boolean enableShardControls = dataSource.getName() == null || Boolean.parseBoolean(connectionInfo.getProperty(PROP_IS_SHARD));
        this.createShardGroup(container, enableShardControls);
        this.setControl((Control)container);
        this.loadSettings();
    }

    private void createShardGroup(Composite parent, boolean enableControls) {
        Group shardGroup = new Group(parent, 0);
        shardGroup.setText(CubridMessages.dialog_connection_cubrid_properties_shard_setting);
        shardGroup.setToolTipText(CubridMessages.dialog_connection_cubrid_properties_shard_tooltip);
        shardGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        shardGroup.setLayout((Layout)new GridLayout(2, false));
        this.shardTypeCombo = UIUtils.createLabelCombo((Composite)shardGroup, (String)"Shard Hint", (int)12);
        this.shardTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.shardTypeCombo.add(SHARD_TYPE_ID);
        this.shardTypeCombo.add(SHARD_TYPE_VAL);
        this.shardVal = UIUtils.createLabelText((Composite)shardGroup, (String)"Value", (String)"");
        this.shardVal.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.shardTypeCombo.setEnabled(enableControls);
        this.shardVal.setEnabled(enableControls);
    }

    public void loadSettings() {
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        String shardType = connectionInfo.getProperty(PROP_SHARD_TYPE);
        String shardValue = connectionInfo.getProperty(PROP_SHARD_VALUE);
        if (CommonUtils.isEmpty((String)shardType)) {
            shardType = SHARD_TYPE_ID;
        }
        if (CommonUtils.isEmpty((String)shardValue)) {
            shardValue = DEFAULT_SHARD_VALUE;
        }
        this.shardTypeCombo.setText(shardType);
        this.shardVal.setText(shardValue);
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.shardTypeCombo != null && this.shardVal != null) {
            int shardValue;
            String shardType = this.shardTypeCombo.getText().trim();
            String shardValueStr = this.shardVal.getText().trim();
            try {
                shardValue = Integer.parseInt(shardValueStr);
            }
            catch (NumberFormatException e) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)CubridMessages.dialog_connection_cubrid_properties_invalid_input_title, (String)CubridMessages.dialog_connection_cubrid_properties_invalid_input_message, (int)1);
                return;
            }
            if (SHARD_TYPE_ID.equals(shardType) && (shardValue < 0 || shardValue > 1)) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)CubridMessages.dialog_connection_cubrid_properties_invalid_shard_id_title, (String)CubridMessages.dialog_connection_cubrid_properties_invalid_shard_id_message, (int)1);
                return;
            }
            connectionInfo.setProperty(PROP_SHARD_TYPE, shardType);
            connectionInfo.setProperty(PROP_SHARD_VALUE, shardValueStr);
        }
        super.saveSettings(dataSource);
    }

    public boolean isComplete() {
        return true;
    }
}

