/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RpcException;
import org.jkiss.utils.rest.RpcInvocationHandler;

public abstract class HttpTransportInvocationHandler
extends RpcInvocationHandler {
    private static final Pattern ST_LINE_PATTERN = Pattern.compile("\\s*at\\s+([\\w/.$]+)\\((.+)\\)");
    private final ExecutorService httpExecutor = Executors.newSingleThreadExecutor();
    private final HttpClient client;

    protected HttpTransportInvocationHandler(@NotNull Class<?> clientClass, @NotNull URI uri, @NotNull Gson gson, @NotNull String userAgent, @Nullable SSLContext sslContext) {
        super(clientClass, uri, gson, userAgent);
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().executor(this.httpExecutor).cookieHandler(new CookieManager());
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        this.client = clientBuilder.build();
    }

    protected String invokeRemoteMethodOverHttp(@NotNull URI methodURI, @NotNull String requestString, RequestMapping methodMapping) throws IOException, InterruptedException {
        HttpResponse.BodyHandler readerBodyHandler = info -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(methodURI).header("Content-Type", "application/json").header("User-Agent", this.userAgent).POST(HttpRequest.BodyPublishers.ofString(requestString));
        if (methodMapping != null && methodMapping.timeout() > 0) {
            builder.timeout(Duration.ofSeconds(methodMapping.timeout()));
        }
        HttpResponse response = this.client.send(builder.build(), readerBodyHandler);
        String contents = (String)response.body();
        if (response.statusCode() != 200) {
            this.handleHttpError(contents);
        }
        return contents;
    }

    @Override
    protected boolean isClientClosed() {
        return this.httpExecutor == null || this.httpExecutor.isShutdown() || this.httpExecutor.isTerminated();
    }

    @Override
    protected void closeClient() {
        if (!this.httpExecutor.isShutdown()) {
            this.httpExecutor.shutdown();
        }
    }

    protected void handleHttpError(String contents) throws RpcException {
        if (contents.startsWith("<")) {
            throw new RpcException(contents);
        }
        String[] stackTraceRows = contents.split("\n");
        StringBuilder errorLineBuilder = new StringBuilder(stackTraceRows[0]);
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        for (int i = 1; i < stackTraceRows.length; ++i) {
            Matcher matcher = ST_LINE_PATTERN.matcher(stackTraceRows[i]);
            if (matcher.find()) {
                int fileLine;
                String fileName;
                String methodRef = matcher.group(1);
                int divPos = methodRef.lastIndexOf(46);
                String className = methodRef.substring(0, divPos);
                String methodName = methodRef.substring(divPos + 1);
                String classRef = matcher.group(2);
                divPos = classRef.indexOf(58);
                if (divPos == -1) {
                    fileName = classRef;
                    fileLine = -1;
                } else {
                    fileName = classRef.substring(0, divPos).trim();
                    fileLine = CommonUtils.toInt(classRef.substring(divPos + 1).trim());
                }
                stackTraceElements.add(new StackTraceElement(className, methodName, fileName, fileLine));
                continue;
            }
            errorLineBuilder.append(CommonUtils.getLineSeparator());
            errorLineBuilder.append(stackTraceRows[i]);
        }
        RpcException runtimeException = new RpcException(errorLineBuilder.toString());
        Collections.addAll(stackTraceElements, runtimeException.getStackTrace());
        runtimeException.setStackTrace(stackTraceElements.toArray(new StackTraceElement[0]));
        throw runtimeException;
    }
}

