/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.TextViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.ContentValueManager;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;

public class UUIDValueManager
extends ContentValueManager {
    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: {
                return new StringInlineEditor(controller){

                    @Override
                    public Object extractEditorValue() throws DBCException {
                        Object strValue = super.extractEditorValue();
                        if (strValue instanceof String) {
                            if (((String)strValue).isEmpty()) {
                                return null;
                            }
                            try {
                                return UUID.fromString((String)strValue);
                            }
                            catch (Exception exception) {
                                throw new DBCException("Bad UUID value [" + String.valueOf(strValue) + "]");
                            }
                        }
                        return strValue;
                    }
                };
            }
            case PANEL: {
                return new ContentPanelEditor(controller){

                    @Override
                    public Object extractEditorValue() throws DBException {
                        Object strValue = super.extractEditorValue();
                        if (strValue instanceof String) {
                            if (((String)strValue).isEmpty()) {
                                return null;
                            }
                            try {
                                return UUID.fromString((String)strValue);
                            }
                            catch (Exception exception) {
                                throw new DBCException("Bad UUID value [" + String.valueOf(strValue) + "]");
                            }
                        }
                        return strValue;
                    }
                };
            }
            case EDITOR: {
                if (controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.string.use.content.editor")) {
                    return ContentEditor.openEditor(controller);
                }
                return new TextViewDialog(controller);
            }
        }
        return null;
    }
}

