﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/client/GenericClientConfiguration.h>
#include <aws/core/endpoint/DefaultEndpointProvider.h>
#include <aws/core/endpoint/EndpointParameter.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iotevents/IoTEventsEndpointRules.h>
#include <aws/iotevents/IoTEvents_EXPORTS.h>

namespace Aws {
namespace IoTEvents {
namespace Endpoint {
using EndpointParameters = Aws::Endpoint::EndpointParameters;
using Aws::Endpoint::DefaultEndpointProvider;
using Aws::Endpoint::EndpointProviderBase;

using IoTEventsClientContextParameters = Aws::Endpoint::ClientContextParameters;

using IoTEventsClientConfiguration = Aws::Client::GenericClientConfiguration;
using IoTEventsBuiltInParameters = Aws::Endpoint::BuiltInParameters;

/**
 * The type for the IoTEvents Client Endpoint Provider.
 * Inherit from this Base class / "Interface" should you want to provide a custom endpoint provider.
 * The SDK must use service-specific type for each service per specification.
 */
using IoTEventsEndpointProviderBase =
    EndpointProviderBase<IoTEventsClientConfiguration, IoTEventsBuiltInParameters, IoTEventsClientContextParameters>;

using IoTEventsDefaultEpProviderBase =
    DefaultEndpointProvider<IoTEventsClientConfiguration, IoTEventsBuiltInParameters, IoTEventsClientContextParameters>;

/**
 * Default endpoint provider used for this service
 */
class AWS_IOTEVENTS_API IoTEventsEndpointProvider : public IoTEventsDefaultEpProviderBase {
 public:
  using IoTEventsResolveEndpointOutcome = Aws::Endpoint::ResolveEndpointOutcome;

  IoTEventsEndpointProvider()
      : IoTEventsDefaultEpProviderBase(Aws::IoTEvents::IoTEventsEndpointRules::GetRulesBlob(),
                                       Aws::IoTEvents::IoTEventsEndpointRules::RulesBlobSize) {}

  ~IoTEventsEndpointProvider() {}
};
}  // namespace Endpoint
}  // namespace IoTEvents
}  // namespace Aws
