﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/entityresolution/EntityResolution_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EntityResolution {
namespace Model {

/**
 * <p>An object containing an error message, if there was an error.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/ErrorDetails">AWS
 * API Reference</a></p>
 */
class ErrorDetails {
 public:
  AWS_ENTITYRESOLUTION_API ErrorDetails() = default;
  AWS_ENTITYRESOLUTION_API ErrorDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_ENTITYRESOLUTION_API ErrorDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ENTITYRESOLUTION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The error message from the job, if there is one.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  ErrorDetails& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace EntityResolution
}  // namespace Aws
