/**
 * @param value 64-bit bigint
 * @returns 16-length hex string in big-endian
 */
export declare function bigUInt64ToHexBE(value: bigint): string;
/**
 * @param value 64-bit bigint
 * @returns 8-bytelength buffer in little-endian
 */
export declare function bigUInt64ToBufferLE(value: bigint): Buffer;
/**
 * @param value 64-bit bigint
 * @returns 8-bytelength buffer in big-endian
 */
export declare function bigUInt64ToBufferBE(value: bigint): Buffer;
//# sourceMappingURL=utils.d.ts.map