/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.solr.api.ClusterPluginsSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.admin.ContainerPluginsApi;

public class NodeConfigClusterPluginsSource
implements ClusterPluginsSource {
    private final Map<String, Object> plugins;
    private final ContainerPluginsApi api;

    public NodeConfigClusterPluginsSource(CoreContainer cc) {
        this.api = new ContainerPluginsApi(cc, this);
        this.plugins = Map.copyOf(NodeConfigClusterPluginsSource.readPlugins(cc.getNodeConfig()));
    }

    @Override
    public ContainerPluginsApi.Read getReadApi() {
        return this.api.readAPI;
    }

    @Override
    public ContainerPluginsApi.Edit getEditApi() {
        return null;
    }

    @Override
    public Map<String, Object> plugins() throws IOException {
        return this.plugins;
    }

    @Override
    public void persistPlugins(Function<Map<String, Object>, Map<String, Object>> modifier) {
        throw new UnsupportedOperationException("The NodeConfigContainerPluginsSource does not support updates to plugin configurations");
    }

    private static Map<String, Object> readPlugins(NodeConfig cfg) {
        HashMap<String, Object> pluginInfos = new HashMap<String, Object>();
        PluginInfo[] clusterPlugins = cfg.getClusterPlugins();
        if (clusterPlugins != null) {
            for (PluginInfo p : clusterPlugins) {
                HashMap<String, Object> pluginMap = new HashMap<String, Object>();
                String pluginName = NodeConfigClusterPluginsSource.getPluginName(p);
                pluginMap.put("name", pluginName);
                pluginMap.put("class", p.className);
                if (p.initArgs.size() > 0) {
                    Map config = p.initArgs.toMap(new HashMap());
                    pluginMap.put("config", config);
                }
                pluginInfos.put(pluginName, pluginMap);
            }
        }
        return pluginInfos;
    }

    private static String getPluginName(PluginInfo pluginInfo) {
        if (pluginInfo.name == null && pluginInfo.type.equals("replicaPlacementFactory")) {
            return ".placement-plugin";
        }
        return pluginInfo.name;
    }
}

