/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

public class PatternUtils {
    public static String preProcessPattern(String pattern) {
        int index = pattern.indexOf(92);
        if (index < 0) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        block9: while (pos < pattern.length()) {
            char ch = pattern.charAt(pos);
            if (ch != '\\') {
                sb.append(ch);
                ++pos;
                continue;
            }
            if (pos + 1 >= pattern.length()) {
                sb.append(ch);
                break;
            }
            ch = pattern.charAt(++pos);
            switch (ch) {
                case 'b': {
                    sb.append('\b');
                    ++pos;
                    continue block9;
                }
                case 'f': {
                    sb.append('\f');
                    ++pos;
                    continue block9;
                }
                case 'n': {
                    sb.append('\n');
                    ++pos;
                    continue block9;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    pos += PatternUtils.radixCharsToChar(sb, pattern, pos, 3, 8);
                    continue block9;
                }
                case 'r': {
                    sb.append('\r');
                    ++pos;
                    continue block9;
                }
                case 't': {
                    sb.append('\t');
                    ++pos;
                    continue block9;
                }
                case 'x': {
                    int adjust = PatternUtils.radixCharsToChar(sb, pattern, pos + 1, 2, 16);
                    if (adjust > 0) {
                        pos += 1 + adjust;
                        continue block9;
                    }
                    sb.append(ch);
                    ++pos;
                    continue block9;
                }
            }
            sb.append(ch);
            ++pos;
        }
        return sb.toString();
    }

    private static int radixCharsToChar(StringBuilder sb, String pattern, int pos, int maxLen, int radix) {
        int digit;
        int i;
        int val = 0;
        for (i = 0; i < maxLen && pos + i < pattern.length() && (digit = Character.digit(pattern.charAt(pos + i), radix)) >= 0; ++i) {
            val = val * radix + digit;
        }
        if (i > 0) {
            sb.append((char)val);
        }
        return i;
    }
}

