/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.paths;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import xsbt.boot.internal.shaded.coursier.cache.shaded.dirs.GetWinDirs;
import xsbt.boot.internal.shaded.coursier.cache.shaded.dirs.ProjectDirectories;
import xsbt.boot.internal.shaded.coursier.jniutils.WindowsKnownFolders;
import xsbt.boot.internal.shaded.coursier.paths.Util;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static volatile File archiveCacheDirectory0;
    private static volatile File jvmCacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File[] configDirectories0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;
    private static Path scalaConfigFile0;

    private static String computeCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_CACHE", "xsbt.boot.internal.shaded.coursier.cache", "v1");
    }

    private static String computeCacheDirectory(String object, String string, String string2) throws IOException {
        if ((object = System.getenv((String)object)) == null) {
            object = System.getProperty(string);
        }
        if (object != null) {
            return object;
        }
        object = new File(CoursierPaths.coursierDirectories().cacheDir);
        object = new File((File)object, string2);
        Util.createDirectories(((File)object).toPath());
        return ((File)object).getAbsolutePath();
    }

    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    public static ProjectDirectories directoriesInstance(String string) {
        GetWinDirs getWinDirs = Util.useJni() ? stringArray -> {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = WindowsKnownFolders.knownFolderPath("{" + stringArray[i] + "}");
            }
            return stringArray2;
        } : GetWinDirs.powerShellBased;
        return ProjectDirectories.from(null, null, string, getWinDirs);
    }

    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = CoursierPaths.directoriesInstance("Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static File[] computeConfigDirectories() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("xsbt.boot.internal.shaded.coursier.config-dir");
        }
        if (string != null) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        string = CoursierPaths.coursierDirectories().configDir;
        String string2 = CoursierPaths.coursierDirectories().preferenceDir;
        if (string.equals(string2)) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        return new File[]{new File(string).getAbsoluteFile(), new File(string2).getAbsoluteFile()};
    }

    public static File[] configDirectories() throws IOException {
        if (configDirectories0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectories0 == null) {
                    configDirectories0 = CoursierPaths.computeConfigDirectories();
                }
            }
        }
        return (File[])configDirectories0.clone();
    }

    public static Path scalaConfigFile() throws Throwable {
        if (scalaConfigFile0 == null) {
            Path path = null;
            Object object = System.getenv("SCALA_CLI_CONFIG");
            if (object != null && ((String)object).length() > 0) {
                path = Paths.get((String)object, new String[0]);
            }
            if (path == null && (object = System.getProperty("scala-cli.config")) != null && ((String)object).length() > 0) {
                path = Paths.get((String)object, new String[0]);
            }
            if (path == null) {
                object = CoursierPaths.directoriesInstance("ScalaCli");
                path = Paths.get(((ProjectDirectories)object).dataLocalDir, new String[0]).resolve("secrets/config.json");
            }
            scalaConfigFile0 = path;
        }
        return scalaConfigFile0;
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        archiveCacheDirectory0 = null;
        jvmCacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectories0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
        scalaConfigFile0 = null;
    }
}

