/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalarAttributeType {
    S("S"),
    N("N"),
    B("B"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalarAttributeType> VALUE_MAP;
    private final String value;

    private ScalarAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalarAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalarAttributeType> knownValues() {
        EnumSet<ScalarAttributeType> knownValues = EnumSet.allOf(ScalarAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalarAttributeType.class, ScalarAttributeType::toString);
    }
}

