/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.LruDocumentCache;
import org.opensearch.neuralsearch.sparse.cache.LruTermCache;
import org.opensearch.neuralsearch.sparse.cache.MemoryUsageManager;

public abstract class MemMonitoredCache<T extends Accountable>
implements Accountable {
    protected final Map<CacheKey, T> cacheMap = new ConcurrentHashMap<CacheKey, T>();

    public void onIndexRemoval(@NonNull CacheKey key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        this.cacheMap.computeIfPresent(key, (k, value) -> {
            long ramBytesUsed = value.ramBytesUsed() + RamUsageEstimator.shallowSizeOf((Object)k);
            MemoryUsageManager.getInstance().getMemoryUsageTracker().recordWithoutValidation(-ramBytesUsed, CircuitBreakerManager::addWithoutBreaking);
            LruTermCache.getInstance().onIndexRemoval((CacheKey)k);
            LruDocumentCache.getInstance().onIndexRemoval((CacheKey)k);
            return null;
        });
    }

    @NonNull
    protected T getOrCreate(@NonNull CacheKey key, @NonNull Function<CacheKey, T> creator) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(creator, "creator is marked non-null but is null");
        return (T)this.cacheMap.computeIfAbsent(key, k -> {
            Accountable value = (Accountable)creator.apply((CacheKey)k);
            MemoryUsageManager.getInstance().getMemoryUsageTracker().recordWithoutValidation(RamUsageEstimator.shallowSizeOf((Object)k), CircuitBreakerManager::addWithoutBreaking);
            return value;
        });
    }

    public T get(@NonNull CacheKey key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return (T)((Accountable)this.cacheMap.get(key));
    }

    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf(this.cacheMap);
        for (Map.Entry<CacheKey, T> entry : this.cacheMap.entrySet()) {
            mem += RamUsageEstimator.shallowSizeOf((Object)entry.getKey());
            mem += ((Accountable)entry.getValue()).ramBytesUsed();
        }
        return mem;
    }
}

