/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.get;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.indexmanagement.rollup.action.get.GetRollupRequest;
import org.opensearch.indexmanagement.rollup.action.get.GetRollupResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/get/TransportGetRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/get/GetRollupRequest;", "Lorg/opensearch/indexmanagement/rollup/action/get/GetRollupResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-index-management"})
public final class TransportGetRollupAction
extends HandledTransportAction<GetRollupRequest, GetRollupResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportGetRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/get", transportService, actionFilters, GetRollupRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetRollupAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetRollupRequest request, @NotNull ActionListener<GetRollupResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId()).preference(request.getPreference());
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(listener, this, user, request){
                final /* synthetic */ ActionListener<GetRollupResponse> $listener;
                final /* synthetic */ TransportGetRollupAction this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ GetRollupRequest $request;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(GetResponse response2) {
                    GetRollupResponse getRollupResponse;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Rollup rollup2 = null;
                    try {
                        rollup2 = RollupUtilsKt.parseRollup(response2, this.this$0.getXContentRegistry());
                    }
                    catch (IllegalArgumentException e) {
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    User user = rollup2.getUser();
                    Boolean bl = TransportGetRollupAction.access$getFilterByEnabled$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"access$getFilterByEnabled$p(...)");
                    if (!SecurityUtils.Companion.userHasPermissionForResource(this.$user, user, bl, "rollup", this.$request.getId(), this.$listener)) {
                        return;
                    }
                    if (this.$request.getSrcContext() != null && !this.$request.getSrcContext().fetchSource()) {
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        getRollupResponse = new GetRollupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, null);
                    } else {
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        getRollupResponse = new GetRollupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, rollup2);
                    }
                    GetRollupResponse rollupResponse = getRollupResponse;
                    this.$listener.onResponse((Object)((Object)rollupResponse));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.onFailure(e);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda$0(TransportGetRollupAction this$0, Boolean it) {
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportGetRollupAction $this) {
        return $this.filterByEnabled;
    }
}

