"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputIsSQL = exports.inputIsQuery = exports.inputIsPPL = exports.getQueryOutput = exports.formatNotRecognized = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const inputIsQuery = inputText => {
  return inputIsSQL(inputText) || inputIsPPL(inputText);
};
exports.inputIsQuery = inputIsQuery;
const inputIsSQL = inputText => {
  return inputText.substring(0, 4) === '%sql';
};
exports.inputIsSQL = inputIsSQL;
const inputIsPPL = inputText => {
  return inputText.substring(0, 4) === '%ppl';
};
exports.inputIsPPL = inputIsPPL;
const getQueryOutput = async (inputText, queryService) => {
  let output = {};
  if (inputIsSQL(inputText)) {
    output = await queryService.describeSQLQuery(inputText);
  } else if (inputIsPPL(inputText)) {
    output = await queryService.describePPLQuery(inputText);
  }
  return output;
};
exports.getQueryOutput = getQueryOutput;
const formatNotRecognized = inputText => {
  return inputText.substring(0, 4) !== '%sql' && inputText.substring(0, 4) !== '%ppl' && inputText.substring(0, 3) !== '%md';
};
exports.formatNotRecognized = formatNotRecognized;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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