"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTitle = getTitle;
var _utils = require("../utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

async function getTitle(client, dataViewId, dataSourceIdToTitle) {
  const savedObject = await client.get('index-pattern', dataViewId);
  if (savedObject.error) {
    throw new Error(`Unable to get index-pattern title: ${savedObject.error.message}`);
  }
  const dataSourceReference = (0, _utils.getDataSourceReference)(savedObject.references);
  if (dataSourceReference) {
    const dataSourceId = dataSourceReference.id;
    if (dataSourceIdToTitle.has(dataSourceId)) {
      return (0, _utils.concatDataSourceWithDataView)(dataSourceIdToTitle.get(dataSourceId), savedObject.attributes.title);
    }
  }
  const getDataSource = async id => await client.get('data-source', id);
  return (0, _utils.getDataViewTitle)(savedObject.attributes.title, savedObject.references, getDataSource);
}