/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;

public class DoublesSketchIterator {
    private final DoublesSketch sketch_;
    private DoublesSketchAccessor sketchAccessor_;
    private long bits_;
    private int level_;
    private long weight_;
    private int i_;

    DoublesSketchIterator(DoublesSketch sketch, long bitPattern) {
        this.sketch_ = sketch;
        this.bits_ = bitPattern;
        this.level_ = -1;
        this.weight_ = 1L;
        this.i_ = 0;
    }

    public boolean next() {
        if (this.sketchAccessor_ == null) {
            this.sketchAccessor_ = DoublesSketchAccessor.wrap(this.sketch_);
        } else {
            ++this.i_;
        }
        if (this.i_ < this.sketchAccessor_.numItems()) {
            return true;
        }
        do {
            ++this.level_;
            if (this.level_ > 0) {
                this.bits_ >>>= 1;
            }
            if (this.bits_ == 0L) {
                return false;
            }
            this.weight_ *= 2L;
        } while ((this.bits_ & 1L) == 0L);
        this.i_ = 0;
        this.sketchAccessor_.setLevel(this.level_);
        return true;
    }

    public double getValue() {
        return this.sketchAccessor_.get(this.i_);
    }

    public long getWeight() {
        return this.weight_;
    }
}

