/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ParametersDiffResult;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedApiResponse;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.utils.ChangedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationDiff {
    private static final Logger log = LoggerFactory.getLogger(OperationDiff.class);
    private final OpenApiDiff openApiDiff;

    public OperationDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public DeferredChanged<ChangedOperation> diff(Operation oldOperation, Operation newOperation, DiffContext context) {
        ChangedOperation changedOperation;
        DeferredBuilder builder;
        block10: {
            block9: {
                block8: {
                    block7: {
                        builder = new DeferredBuilder();
                        changedOperation = new ChangedOperation(context.getUrl(), context.getMethod(), oldOperation, newOperation);
                        log.debug("Diff operation {} {}", (Object)changedOperation.getPathUrl(), (Object)changedOperation.getHttpMethod());
                        builder.with(this.openApiDiff.getMetadataDiff().diff(oldOperation.getSummary(), newOperation.getSummary(), context)).ifPresent(changedOperation::setSummary);
                        builder.with(this.openApiDiff.getMetadataDiff().diff(oldOperation.getDescription(), newOperation.getDescription(), context)).ifPresent(changedOperation::setDescription);
                        builder.with(this.openApiDiff.getOperationIdDiff().diff(oldOperation.getOperationId(), newOperation.getOperationId(), context)).ifPresent(changedOperation::setOperationId);
                        changedOperation.setDeprecated(!Objects.equals(oldOperation.getDeprecated(), newOperation.getDeprecated()));
                        if (oldOperation.getRequestBody() != null) break block7;
                        if (newOperation.getRequestBody() == null) break block8;
                    }
                    builder.with(this.openApiDiff.getRequestBodyDiff().diff(oldOperation.getRequestBody(), newOperation.getRequestBody(), context.copyAsRequest())).ifPresent(changedOperation::setRequestBody);
                }
                ParametersDiffResult parametersDiffResult = this.openApiDiff.getParametersDiff().diff(oldOperation.getParameters(), newOperation.getParameters(), context);
                builder.with(parametersDiffResult.deferredChanged).ifPresent(params -> {
                    if (!parametersDiffResult.sameOperationsDiffSchema) {
                        this.removePathParameters(context.getParameters(), (ChangedParameters)params);
                    }
                    changedOperation.setParameters((ChangedParameters)params);
                });
                if (oldOperation.getResponses() != null || newOperation.getResponses() != null) {
                    builder.with(this.openApiDiff.getApiResponseDiff().diff(oldOperation.getResponses(), newOperation.getResponses(), context.copyAsResponse())).ifPresent(responses -> {
                        log.debug("operation " + changedOperation.getPathUrl() + " " + (Object)((Object)changedOperation.getHttpMethod()) + " setting api responses " + responses.getChangedElements().stream().filter(Objects::nonNull).map(Changed::isChanged).filter(Objects::nonNull).map(Enum::toString).collect(Collectors.joining(",")));
                        changedOperation.setApiResponses((ChangedApiResponse)responses);
                    });
                }
                if (oldOperation.getSecurity() != null) break block9;
                if (newOperation.getSecurity() == null) break block10;
            }
            builder.with(this.openApiDiff.getSecurityRequirementsDiff().diff(oldOperation.getSecurity(), newOperation.getSecurity(), context)).ifPresent(changedOperation::setSecurityRequirements);
        }
        builder.with(this.openApiDiff.getExtensionsDiff().diff(oldOperation.getExtensions(), newOperation.getExtensions(), context)).ifPresent(changedOperation::setExtensions);
        return builder.build().mapOptional(value -> {
            Optional<ChangedOperation> changed = ChangedUtils.isChanged(changedOperation);
            log.debug("Is changed operation " + changedOperation.getPathUrl() + " " + (Object)((Object)changedOperation.getHttpMethod()) + " changed: " + changed.map(ComposedChanged::isChanged).orElse(null));
            return changed;
        });
    }

    public void removePathParameters(Map<String, String> pathParameters, ChangedParameters params) {
        pathParameters.forEach((oldParam, newParam) -> {
            this.removePathParameter((String)oldParam, params.getMissing());
            this.removePathParameter((String)newParam, params.getIncreased());
        });
    }

    public void removePathParameter(String name, List<Parameter> parameters) {
        parameters.stream().filter(p -> "path".equals(p.getIn()) && name.equals(p.getName())).findFirst().ifPresent(parameters::remove);
    }
}

