/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import shadow.bundletool.com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i15 = 0;
        block0: while (i15 < escapedLength) {
            for (int j15 = 0; j15 < ENCODED.length; ++j15) {
                String toReplace = ENCODED[j15];
                if (i15 + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i15, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k15 = 0; k15 < i15; ++k15) {
                        offsetMap[k15] = k15;
                        decodedValue.append(encodedValue.charAt(k15));
                    }
                }
                decodedValue.append(DECODED[j15]);
                offsetMap[decodedValue.length() - 1] = i15 += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i15));
                offsetMap[decodedValue.length() - 1] = i15;
            }
            ++i15;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

