/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ide.common.blame;

import com.google.common.base.Objects;
import java.io.File;
import java.io.Serializable;

public final class SourceFile
implements Serializable {
    public static final SourceFile UNKNOWN = new SourceFile();
    private final String mFilePath;
    private String mSourcePath;
    private final String mDescription;

    public SourceFile(File sourceFile, String description) {
        this.mFilePath = sourceFile.getAbsolutePath();
        this.mDescription = description;
    }

    public SourceFile(File sourceFile) {
        this(sourceFile, null);
    }

    public SourceFile(String description) {
        this.mFilePath = null;
        this.mDescription = description;
    }

    private SourceFile() {
        this.mFilePath = null;
        this.mDescription = null;
    }

    public void setOverrideSourcePath(String value) {
        this.mSourcePath = value;
    }

    public File getSourceFile() {
        if (this.mFilePath != null) {
            return new File(this.mFilePath);
        }
        return null;
    }

    public String getSourcePath() {
        if (this.mSourcePath != null) {
            return this.mSourcePath;
        }
        if (this.mFilePath != null) {
            return this.mFilePath;
        }
        return null;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceFile)) {
            return false;
        }
        SourceFile other = (SourceFile)obj;
        return Objects.equal(this.mDescription, other.mDescription) && Objects.equal(this.getSourcePath(), other.getSourcePath());
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourcePath(), this.mDescription);
    }

    public String toString() {
        return this.print(false);
    }

    public String print(boolean shortFormat) {
        String fileDisplayName;
        String path;
        if (this.mSourcePath != null) {
            path = this.mSourcePath;
        } else if (this.mFilePath != null) {
            path = this.mFilePath;
        } else {
            if (this.mDescription == null) {
                return "Unknown source file";
            }
            return this.mDescription;
        }
        String fileName = new File(path).getName();
        String string = fileDisplayName = shortFormat ? fileName : path;
        if (this.mDescription == null || this.mDescription.equals(fileName)) {
            return fileDisplayName;
        }
        return String.format("[%1$s] %2$s", this.mDescription, fileDisplayName);
    }
}

