/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.SuppressFBWarnings;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List<ParameterizedCompletion.Parameter> params;
    private String returnValDesc;
    private String compareString;

    public FunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    @Override
    protected void addDefinitionString(StringBuilder sb5) {
        sb5.append("<html><b>");
        sb5.append(this.getDefinitionString());
        sb5.append("</b>");
    }

    protected void addParameters(StringBuilder sb5) {
        int paramCount = this.getParamCount();
        if (paramCount > 0) {
            sb5.append("<b>Parameters:</b><br>");
            sb5.append("<center><table width='90%'><tr><td>");
            for (int i15 = 0; i15 < paramCount; ++i15) {
                ParameterizedCompletion.Parameter param = this.getParam(i15);
                sb5.append("<b>");
                sb5.append(param.getName() != null ? param.getName() : param.getType());
                sb5.append("</b>&nbsp;");
                String desc = param.getDescription();
                if (desc != null) {
                    sb5.append(desc);
                }
                sb5.append("<br>");
            }
            sb5.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            sb5.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            sb5.append(this.returnValDesc);
            sb5.append("</td></tr></table></center><br><br>");
        }
    }

    @Override
    public int compareTo(Completion c25) {
        int rc5 = c25 == this ? 0 : (c25 instanceof FunctionCompletion ? this.getCompareString().compareTo(((FunctionCompletion)c25).getCompareString()) : super.compareTo(c25));
        return rc5;
    }

    public boolean equals(Object other) {
        return other instanceof Completion && this.compareTo((Completion)other) == 0;
    }

    private String getCompareString() {
        if (this.compareString == null) {
            StringBuilder sb5 = new StringBuilder(this.getName());
            int paramCount = this.getParamCount();
            if (paramCount < 10) {
                sb5.append('0');
            }
            sb5.append(paramCount);
            for (int i15 = 0; i15 < paramCount; ++i15) {
                String type = this.getParam(i15).getType();
                sb5.append(type);
                if (i15 >= paramCount - 1) continue;
                sb5.append(',');
            }
            this.compareString = sb5.toString();
        }
        return this.compareString;
    }

    @Override
    public String getDefinitionString() {
        StringBuilder sb5 = new StringBuilder();
        String type = this.getType();
        if (type != null) {
            sb5.append(type).append(' ');
        }
        sb5.append(this.getName());
        CompletionProvider provider = this.getProvider();
        char start = provider.getParameterListStart();
        if (start != '\u0000') {
            sb5.append(start);
        }
        for (int i15 = 0; i15 < this.getParamCount(); ++i15) {
            ParameterizedCompletion.Parameter param = this.getParam(i15);
            type = param.getType();
            String name = param.getName();
            if (type != null) {
                sb5.append(type);
                if (name != null) {
                    sb5.append(' ');
                }
            }
            if (name != null) {
                sb5.append(name);
            }
            if (i15 >= this.params.size() - 1) continue;
            sb5.append(provider.getParameterListSeparator());
        }
        char end = provider.getParameterListEnd();
        if (end != '\u0000') {
            sb5.append(end);
        }
        return sb5.toString();
    }

    @Override
    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent tc5, boolean replaceTabsWithSpaces) {
        ParameterizedCompletionInsertionInfo info = new ParameterizedCompletionInsertionInfo();
        StringBuilder sb5 = new StringBuilder();
        char paramListStart = this.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            sb5.append(paramListStart);
        }
        int dot = tc5.getCaretPosition() + sb5.length();
        int paramCount = this.getParamCount();
        Position maxPos = null;
        try {
            maxPos = tc5.getDocument().createPosition(dot - sb5.length() + 1);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        info.setCaretRange(dot, maxPos);
        int firstParamLen = 0;
        int start = dot;
        for (int i15 = 0; i15 < paramCount; ++i15) {
            ParameterizedCompletion.Parameter param = this.getParam(i15);
            String paramText = this.getParamText(param);
            if (i15 == 0) {
                firstParamLen = paramText.length();
            }
            sb5.append(paramText);
            int end = start + paramText.length();
            info.addReplacementLocation(start, end);
            String sep = this.getProvider().getParameterListSeparator();
            if (i15 >= paramCount - 1 || sep == null) continue;
            sb5.append(sep);
            start = end + sep.length();
        }
        char charListEnd = this.getProvider().getParameterListEnd();
        if (charListEnd > '\u0000') {
            sb5.append(this.getProvider().getParameterListEnd());
        }
        int endOffs = dot + sb5.length();
        info.addReplacementLocation(--endOffs, endOffs);
        info.setDefaultEndOffs(endOffs);
        int selectionEnd = paramCount > 0 ? dot + firstParamLen : dot;
        info.setInitialSelection(dot, selectionEnd);
        info.setTextToInsert(sb5.toString());
        return info;
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int index) {
        return this.params.get(index);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public boolean getShowParameterToolTip() {
        return true;
    }

    private String getParamText(ParameterizedCompletion.Parameter param) {
        String text = param.getName();
        if (text == null && (text = param.getType()) == null) {
            text = "arg";
        }
        return text;
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    @Override
    public String getSummary() {
        StringBuilder sb5 = new StringBuilder();
        this.addDefinitionString(sb5);
        if (!this.possiblyAddDescription(sb5)) {
            sb5.append("<br><br><br>");
        }
        this.addParameters(sb5);
        this.possiblyAddDefinedIn(sb5);
        return sb5.toString();
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Subclasses could return null")
    public String getToolTipText() {
        String text = this.getSummary();
        if (text == null) {
            text = this.getDefinitionString();
        }
        return text;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        for (int i15 = 0; i15 < this.getParamCount(); ++i15) {
            hashCode ^= this.getParam(i15).hashCode();
        }
        hashCode ^= this.returnValDesc != null ? this.returnValDesc.hashCode() : 0;
        return hashCode ^= this.compareString != null ? this.compareString.hashCode() : 0;
    }

    public void setParams(List<ParameterizedCompletion.Parameter> params) {
        if (params != null) {
            this.params = new ArrayList<ParameterizedCompletion.Parameter>(params);
        }
    }

    public void setReturnValueDescription(String desc) {
        this.returnValDesc = desc;
    }
}

