/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class IEEE754rUtils {
    public static double max(double ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        double max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            max = IEEE754rUtils.max(array[j15], max);
        }
        return max;
    }

    public static double max(double a15, double b15) {
        if (Double.isNaN(a15)) {
            return b15;
        }
        if (Double.isNaN(b15)) {
            return a15;
        }
        return Math.max(a15, b15);
    }

    public static double max(double a15, double b15, double c15) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a15, b15), c15);
    }

    public static float max(float ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        float max = array[0];
        for (int j15 = 1; j15 < array.length; ++j15) {
            max = IEEE754rUtils.max(array[j15], max);
        }
        return max;
    }

    public static float max(float a15, float b15) {
        if (Float.isNaN(a15)) {
            return b15;
        }
        if (Float.isNaN(b15)) {
            return a15;
        }
        return Math.max(a15, b15);
    }

    public static float max(float a15, float b15, float c15) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a15, b15), c15);
    }

    public static double min(double ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        double min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            min = IEEE754rUtils.min(array[i15], min);
        }
        return min;
    }

    public static double min(double a15, double b15) {
        if (Double.isNaN(a15)) {
            return b15;
        }
        if (Double.isNaN(b15)) {
            return a15;
        }
        return Math.min(a15, b15);
    }

    public static double min(double a15, double b15, double c15) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a15, b15), c15);
    }

    public static float min(float ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        float min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            min = IEEE754rUtils.min(array[i15], min);
        }
        return min;
    }

    public static float min(float a15, float b15) {
        if (Float.isNaN(a15)) {
            return b15;
        }
        if (Float.isNaN(b15)) {
            return a15;
        }
        return Math.min(a15, b15);
    }

    public static float min(float a15, float b15, float c15) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a15, b15), c15);
    }

    @Deprecated
    public IEEE754rUtils() {
    }
}

